/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.logging;

import io.netty.util.DomainNameMapping;
import java.io.Serializable;
import java.util.Arrays;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.RouterLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class RouterLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
RouterLogger,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RouterLogger_$logger.class.getName();
    private static final String initializedSni = "ISPN014001: Using SNI Handler with domain mapping %s";
    private static final String noRouteFound = "ISPN014002: Could not find matching route";
    private static final String hotRodRouterStarted = "ISPN014003: HotRod Router listening on %s";
    private static final String restRouterStarted = "ISPN014004: REST Router listening on %s";
    private static final String printOutRoutingTable = "ISPN014005: Routing table: %s";
    private static final String configurationValidationError = "ISPN014007: Configuration validation error";
    private static final String hotrodRouterStartFailed = "ISPN014008: Unable to start HotRod router";
    private static final String restRouterStartFailed = "ISPN014009: Unable to start REST router";
    private static final String errorWhileShuttingDown = "ISPN014010: Error while shutting down the router";

    public RouterLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void initializedSni(DomainNameMapping domainNameMapping) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.initializedSni$str(), (Object)domainNameMapping);
    }

    protected String initializedSni$str() {
        return initializedSni;
    }

    @Override
    public final IllegalArgumentException noRouteFound() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noRouteFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noRouteFound$str() {
        return noRouteFound;
    }

    @Override
    public final void hotRodRouterStarted(String address) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.hotRodRouterStarted$str(), (Object)address);
    }

    protected String hotRodRouterStarted$str() {
        return hotRodRouterStarted;
    }

    @Override
    public final void restRouterStarted(String address) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.restRouterStarted$str(), (Object)address);
    }

    protected String restRouterStarted$str() {
        return restRouterStarted;
    }

    @Override
    public final void printOutRoutingTable(RoutingTable routingTable) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.printOutRoutingTable$str(), (Object)routingTable);
    }

    protected String printOutRoutingTable$str() {
        return printOutRoutingTable;
    }

    @Override
    public final IllegalStateException configurationValidationError(Exception e) {
        IllegalStateException result = new IllegalStateException(String.format(this.configurationValidationError$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configurationValidationError$str() {
        return configurationValidationError;
    }

    @Override
    public final IllegalStateException hotrodRouterStartFailed(Exception e) {
        IllegalStateException result = new IllegalStateException(String.format(this.hotrodRouterStartFailed$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hotrodRouterStartFailed$str() {
        return hotrodRouterStartFailed;
    }

    @Override
    public final IllegalStateException restRouterStartFailed(Exception e) {
        IllegalStateException result = new IllegalStateException(String.format(this.restRouterStartFailed$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String restRouterStartFailed$str() {
        return restRouterStartFailed;
    }

    @Override
    public final void errorWhileShuttingDown(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWhileShuttingDown$str(), new Object[0]);
    }

    protected String errorWhileShuttingDown$str() {
        return errorWhileShuttingDown;
    }
}

