/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.CountingOutputStream;
import org.jboss.logmanager.handlers.FileHandler;

public class SizeRotatingFileHandler
extends FileHandler {
    private long rotateSize = 655360L;
    private int maxBackupIndex = 1;
    private CountingOutputStream outputStream;
    private boolean rotateOnBoot;
    private String suffix;

    public SizeRotatingFileHandler() {
    }

    public SizeRotatingFileHandler(File file) throws FileNotFoundException {
        super(file);
    }

    public SizeRotatingFileHandler(File file, boolean append) throws FileNotFoundException {
        super(file, append);
    }

    public SizeRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public SizeRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public SizeRotatingFileHandler(long rotateSize, int maxBackupIndex) {
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public SizeRotatingFileHandler(File file, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public SizeRotatingFileHandler(File file, boolean append, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file, append);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputStream(OutputStream outputStream) {
        Object object = this.outputLock;
        synchronized (object) {
            this.outputStream = outputStream == null ? null : new CountingOutputStream(outputStream);
            super.setOutputStream(this.outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFile(File file) throws FileNotFoundException {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.rotateOnBoot && this.maxBackupIndex > 0 && file != null && file.exists() && file.length() > 0L) {
                try {
                    this.rotate(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            super.setFile(file);
            if (this.outputStream != null) {
                this.outputStream.currentSize = file == null ? 0L : file.length();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRotateOnBoot() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.rotateOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotateOnBoot(boolean rotateOnBoot) {
        SizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.rotateOnBoot = rotateOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotateSize(long rotateSize) {
        SizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.rotateSize = rotateSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBackupIndex(int maxBackupIndex) {
        SizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.maxBackupIndex = maxBackupIndex;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuffix(String suffix) {
        SizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.suffix = suffix;
        }
    }

    @Override
    protected void preWrite(ExtLogRecord record) {
        long currentSize;
        int maxBackupIndex = this.maxBackupIndex;
        long l = currentSize = this.outputStream == null ? Long.MIN_VALUE : this.outputStream.currentSize;
        if (currentSize > this.rotateSize && maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.setFile(null);
                this.rotate(file);
                this.setFile(file);
            }
            catch (IOException e) {
                this.reportError("Unable to rotate log file", e, 4);
            }
        }
    }

    private void rotate(File file) throws IOException {
        if (this.suffix == null) {
            Files.deleteIfExists(Paths.get(file.getAbsolutePath() + "." + this.maxBackupIndex, new String[0]));
            for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                Path src = Paths.get(file.getAbsolutePath() + "." + i, new String[0]);
                if (!Files.exists(src, new LinkOption[0])) continue;
                Path target = Paths.get(file.getAbsolutePath() + "." + (i + 1), new String[0]);
                Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(file.toPath(), Paths.get(file.getAbsolutePath() + ".1", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        } else {
            String suffix = new SimpleDateFormat(this.suffix).format(new Date());
            String newBaseFilename = file.getAbsolutePath() + suffix;
            Files.deleteIfExists(Paths.get(newBaseFilename + "." + this.maxBackupIndex, new String[0]));
            for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                Path src = Paths.get(newBaseFilename + "." + i, new String[0]);
                if (!Files.exists(src, new LinkOption[0])) continue;
                Path target = Paths.get(newBaseFilename + "." + (i + 1), new String[0]);
                Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(file.toPath(), Paths.get(newBaseFilename + ".1", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

