/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.ToIntFunction;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.RemovableIterator;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.DataContainerRemoveIterator;
import org.infinispan.util.EntryWrapper;

public class EntrySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public EntrySetCommand(Cache<K, V> cache, long flagsBitSet) {
        this.setFlagsBitSet(flagsBitSet);
        cache = AbstractDelegatingCache.unwrapCache(cache);
        this.cache = flagsBitSet != 0L ? cache.getAdvancedCache().withFlags((Flag[])EnumUtil.enumArrayOf((long)flagsBitSet, Flag.class)) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEntrySetCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<CacheEntry<K, V>> perform(InvocationContext ctx) throws Throwable {
        boolean isRemoteIteration = EnumUtil.containsAny((long)this.getFlagsBitSet(), (long)FlagBitSets.REMOTE_ITERATION);
        Object lockOwner = ctx.getLockOwner();
        if (ctx.getLockOwner() != null) {
            return new BackingEntrySet<K, V>(this.cache.getAdvancedCache().lockAs(lockOwner), isRemoteIteration);
        }
        return new BackingEntrySet<K, V>(this.cache, isRemoteIteration);
    }

    public String toString() {
        return "EntrySetCommand{cache=" + this.cache.getName() + '}';
    }

    static class BackingEntrySet<K, V>
    extends AbstractCollection<CacheEntry<K, V>>
    implements CacheSet<CacheEntry<K, V>> {
        private final boolean isRemoteIteration;
        private final Cache<K, V> cache;

        BackingEntrySet(Cache<K, V> cache, boolean isRemoteIteration) {
            this.cache = cache;
            this.isRemoteIteration = isRemoteIteration;
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            if (this.isRemoteIteration) {
                return Closeables.iterator(this.cache.getAdvancedCache().getDataContainer().iterator());
            }
            DataContainerRemoveIterator<K, V> iterator = new DataContainerRemoveIterator<K, V>(this.cache);
            RemovableIterator removableIterator = new RemovableIterator(iterator, e -> this.cache.remove(e.getKey(), e.getValue()));
            return new CloseableIteratorMapper((Iterator)removableIterator, e -> new EntryWrapper<K, V>(this.cache, e));
        }

        static <K, V> CloseableSpliterator<CacheEntry<K, V>> cast(Spliterator spliterator) {
            if (spliterator instanceof CloseableSpliterator) {
                return (CloseableSpliterator)spliterator;
            }
            return Closeables.spliterator((Spliterator)spliterator);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            DataContainer<K, V> dc = this.cache.getAdvancedCache().getDataContainer();
            return BackingEntrySet.cast(dc.spliterator());
        }

        @Override
        public int size() {
            return this.cache.getAdvancedCache().getDataContainer().size();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                DataContainer<K, V> container = this.cache.getAdvancedCache().getDataContainer();
                InternalCacheEntry<K, V> value = container.get(entry.getKey());
                return value != null && value.getValue().equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            return entry != null && this.cache.remove(entry.getKey(), entry.getValue());
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }

        private ToIntFunction<Object> getSegmentMapper(Cache<K, V> cache) {
            DistributionManager dm = cache.getAdvancedCache().getDistributionManager();
            if (dm != null) {
                return dm.getCacheTopology()::getSegment;
            }
            return null;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier<K, V>(this.cache, this.getSegmentMapper(this.cache), () -> super.stream()), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier<K, V>(this.cache, this.getSegmentMapper(this.cache), () -> super.stream()), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }
}

