/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.primitive.AbstractForEachDoubleOperation;

public class ForEachDoubleOperation<Original, K>
extends AbstractForEachDoubleOperation<Original, K> {
    private final DoubleConsumer consumer;

    public ForEachDoubleOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<Original>> supplier, Function<? super Original, ? extends K> toKeyFunction, int batchSize, DoubleConsumer consumer) {
        super(intermediateOperations, supplier, toKeyFunction, batchSize);
        this.consumer = consumer;
    }

    @Override
    protected void handleArray(double[] array, int size) {
        for (int i = 0; i < size; ++i) {
            this.consumer.accept(array[i]);
        }
    }

    public DoubleConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        super.handleInjection(registry);
        if (this.consumer instanceof CacheAware) {
            ((CacheAware)((Object)this.consumer)).injectCache(registry.getComponent(Cache.class));
        }
    }
}

