/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.AbstractForEachOperation;

public class ForEachFlatMapIntOperation<Original, K>
extends AbstractForEachOperation<Original, K, Integer, IntStream> {
    private final IntConsumer consumer;

    public ForEachFlatMapIntOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<Original>> supplier, Function<? super Original, ? extends K> toKeyFunction, int batchSize, IntConsumer consumer) {
        super(intermediateOperations, supplier, toKeyFunction, batchSize);
        this.consumer = consumer;
    }

    @Override
    protected void handleList(List<Integer> list) {
        list.forEach(this.consumer::accept);
    }

    @Override
    protected void handleStreamForEach(IntStream stream, List<Integer> list) {
        stream.forEach(list::add);
    }

    public IntConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        super.handleInjection(registry);
        if (this.consumer instanceof CacheAware) {
            ((CacheAware)((Object)this.consumer)).injectCache(registry.getComponent(Cache.class));
        }
    }
}

