/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;

class LdapConnectionHandler
implements LdapConnectionManager,
Closeable {
    private final LdapConnectionManager ldapConnectionManager;
    private final LdapConnectionHandler parent;
    private Map<URI, LdapConnectionHandler> cachedLdapConnectionHandlers = null;
    private DirContext cachedDirContext;

    private LdapConnectionHandler(LdapConnectionManager ldapConnectionManager) {
        this.ldapConnectionManager = ldapConnectionManager;
        this.parent = null;
    }

    private LdapConnectionHandler(LdapConnectionHandler parent, LdapConnectionManager ldapConnectionManager) {
        this.parent = parent;
        this.ldapConnectionManager = ldapConnectionManager;
    }

    static LdapConnectionHandler newInstance(LdapConnectionManager ldapConnectionManager) {
        return new LdapConnectionHandler(ldapConnectionManager);
    }

    @Override
    public DirContext getConnection() throws NamingException {
        if (this.cachedDirContext != null) {
            return this.cachedDirContext;
        }
        this.cachedDirContext = this.ldapConnectionManager.getConnection();
        return this.cachedDirContext;
    }

    @Override
    public void verifyIdentity(String bindDn, String bindCredential) throws NamingException {
        this.ldapConnectionManager.verifyIdentity(bindDn, bindCredential);
    }

    @Override
    public LdapConnectionHandler findForReferral(URI referralUri) {
        if (this.cachedLdapConnectionHandlers != null && this.cachedLdapConnectionHandlers.containsKey(referralUri)) {
            return this.cachedLdapConnectionHandlers.get(referralUri);
        }
        LdapConnectionManager nextConnectionManager = this.ldapConnectionManager.findForReferral(referralUri);
        if (nextConnectionManager == null) {
            return null;
        }
        LdapConnectionHandler nextLdapConnectionHandler = nextConnectionManager == this.ldapConnectionManager ? this : new LdapConnectionHandler(this, nextConnectionManager);
        this.cache(referralUri, nextLdapConnectionHandler);
        return nextLdapConnectionHandler;
    }

    @Override
    public void close() throws IOException {
        this.safeClose(this.cachedDirContext);
        if (this.cachedLdapConnectionHandlers != null) {
            for (LdapConnectionHandler current : this.cachedLdapConnectionHandlers.values()) {
                if (current == null) continue;
                current.close();
            }
            this.cachedLdapConnectionHandlers.clear();
        }
    }

    private void safeClose(DirContext d) {
        if (d != null) {
            try {
                d.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cache(URI uri, LdapConnectionHandler handler) {
        if (this.parent != null) {
            this.parent.cache(uri, handler);
        } else {
            if (this.cachedLdapConnectionHandlers == null) {
                this.cachedLdapConnectionHandlers = new HashMap<URI, LdapConnectionHandler>(1);
            }
            this.cachedLdapConnectionHandlers.put(uri, handler);
        }
    }
}

