/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static <T> T newInstance(Class<T> clazz) {
        if (clazz.isAnonymousClass() || clazz.isInterface() || clazz.isAnnotation()) {
            throw new RuntimeException("Can not create new instance of an " + clazz.getName());
        }
        T instance = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            instance = (T)ReflectionUtil.instantiateWithConstructor(constructor);
            if (!ReflectionUtil.isValidInstance(instance)) continue;
            return instance;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            instance = (T)ReflectionUtil.instantiateWithConstructor(constructor);
            if (!ReflectionUtil.isValidInstance(instance)) continue;
            return instance;
        }
        throw new RuntimeException("Could not instantiate class: " + clazz + ", no access to constructors.");
    }

    private static <T> boolean isValidInstance(T instance) {
        return instance != null;
    }

    private static <T> T instantiateWithConstructor(Constructor<T> constructor) {
        T instance = null;
        if (constructor.getParameterTypes().length == 0) {
            instance = ReflectionUtil.newInstanceWithoutParameterTypes(constructor);
        }
        if (constructor.getParameterTypes().length == 1) {
            instance = ReflectionUtil.newInstanceWithParameterTypes(constructor);
        }
        return ReflectionUtil.isValidInstance(instance) ? instance : null;
    }

    private static <T> T newInstanceWithoutParameterTypes(Constructor<T> constructor) {
        try {
            ReflectionUtil.setAccessible(constructor);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static <T> T newInstanceWithParameterTypes(Constructor<T> constructor) {
        Constructor paramConstructor = ReflectionUtil.getConstructorWithNoParams(constructor.getParameterTypes()[0]);
        if (paramConstructor == null) {
            return null;
        }
        ReflectionUtil.setAccessible(constructor);
        try {
            return constructor.newInstance(paramConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static <T> void setAccessible(Constructor<T> constructor) {
        if (Modifier.isPrivate(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers())) {
            constructor.setAccessible(true);
        }
    }

    private static Constructor getConstructorWithNoParams(Class clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            ReflectionUtil.setAccessible(constructor);
            return constructor;
        }
        return null;
    }
}

