/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import protostream.com.squareup.protoparser.AutoValue_ProtoFile;
import protostream.com.squareup.protoparser.ExtendElement;
import protostream.com.squareup.protoparser.OptionElement;
import protostream.com.squareup.protoparser.ServiceElement;
import protostream.com.squareup.protoparser.TypeElement;
import protostream.com.squareup.protoparser.Utils;

public abstract class ProtoFile {
    static final int MIN_TAG_VALUE = 1;
    static final int MAX_TAG_VALUE = 0x1FFFFFFF;
    private static final int RESERVED_TAG_VALUE_START = 19000;
    private static final int RESERVED_TAG_VALUE_END = 19999;

    static boolean isValidTag(int value) {
        return value >= 1 && value < 19000 || value > 19999 && value <= 0x1FFFFFFF;
    }

    public static Builder builder(String filePath) {
        return new Builder(Utils.checkNotNull(filePath, "filePath"));
    }

    ProtoFile() {
    }

    public abstract String filePath();

    public abstract String packageName();

    public abstract Syntax syntax();

    public abstract List<String> dependencies();

    public abstract List<String> publicDependencies();

    public abstract List<TypeElement> typeElements();

    public abstract List<ServiceElement> services();

    public abstract List<ExtendElement> extendDeclarations();

    public abstract List<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        if (!this.filePath().isEmpty()) {
            builder.append("// ").append(this.filePath()).append('\n');
        }
        if (this.packageName() != null) {
            builder.append("package ").append(this.packageName()).append(";\n");
        }
        if (this.syntax() != null) {
            builder.append("syntax \"").append(this.syntax().name).append("\";\n");
        }
        if (!this.dependencies().isEmpty() || !this.publicDependencies().isEmpty()) {
            builder.append('\n');
            for (String dependency : this.dependencies()) {
                builder.append("import \"").append(dependency).append("\";\n");
            }
            for (String publicDependency : this.publicDependencies()) {
                builder.append("import public \"").append(publicDependency).append("\";\n");
            }
        }
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                builder.append(option.toSchemaDeclaration());
            }
        }
        if (!this.typeElements().isEmpty()) {
            builder.append('\n');
            for (TypeElement typeElement : this.typeElements()) {
                builder.append(typeElement.toSchema());
            }
        }
        if (!this.extendDeclarations().isEmpty()) {
            builder.append('\n');
            for (ExtendElement extendDeclaration : this.extendDeclarations()) {
                builder.append(extendDeclaration.toSchema());
            }
        }
        if (!this.services().isEmpty()) {
            builder.append('\n');
            for (ServiceElement service : this.services()) {
                builder.append(service.toSchema());
            }
        }
        return builder.toString();
    }

    public static final class Builder {
        private final String filePath;
        private String packageName;
        private Syntax syntax;
        private final List<String> dependencies = new ArrayList<String>();
        private final List<String> publicDependencies = new ArrayList<String>();
        private final List<TypeElement> types = new ArrayList<TypeElement>();
        private final List<ServiceElement> services = new ArrayList<ServiceElement>();
        private final List<ExtendElement> extendDeclarations = new ArrayList<ExtendElement>();
        private final List<OptionElement> options = new ArrayList<OptionElement>();

        Builder(String filePath) {
            this.filePath = filePath;
        }

        public Builder packageName(String packageName) {
            this.packageName = Utils.checkNotNull(packageName, "packageName");
            return this;
        }

        public Builder syntax(Syntax syntax) {
            this.syntax = Utils.checkNotNull(syntax, "syntax");
            return this;
        }

        public Builder addDependency(String dependency) {
            this.dependencies.add(Utils.checkNotNull(dependency, "dependency"));
            return this;
        }

        public Builder addDependencies(Collection<String> dependencies) {
            for (String dependency : Utils.checkNotNull(dependencies, "dependencies")) {
                this.addDependency(dependency);
            }
            return this;
        }

        public Builder addPublicDependency(String dependency) {
            this.publicDependencies.add(Utils.checkNotNull(dependency, "dependency"));
            return this;
        }

        public Builder addPublicDependencies(Collection<String> dependencies) {
            for (String dependency : Utils.checkNotNull(dependencies, "dependencies")) {
                this.addPublicDependency(dependency);
            }
            return this;
        }

        public Builder addType(TypeElement type) {
            this.types.add(Utils.checkNotNull(type, "type"));
            return this;
        }

        public Builder addTypes(Collection<TypeElement> types) {
            for (TypeElement type : Utils.checkNotNull(types, "types")) {
                this.addType(type);
            }
            return this;
        }

        public Builder addService(ServiceElement service) {
            this.services.add(Utils.checkNotNull(service, "service"));
            return this;
        }

        public Builder addServices(Collection<ServiceElement> services) {
            for (ServiceElement service : Utils.checkNotNull(services, "services")) {
                this.addService(service);
            }
            return this;
        }

        public Builder addExtendDeclaration(ExtendElement extend) {
            this.extendDeclarations.add(Utils.checkNotNull(extend, "extend"));
            return this;
        }

        public Builder addExtendDeclarations(Collection<ExtendElement> extendDeclarations) {
            for (ExtendElement extendDeclaration : Utils.checkNotNull(extendDeclarations, "extendDeclarations")) {
                this.addExtendDeclaration(extendDeclaration);
            }
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public Builder addOptions(Collection<OptionElement> options) {
            for (OptionElement option : Utils.checkNotNull(options, "options")) {
                this.addOption(option);
            }
            return this;
        }

        public ProtoFile build() {
            return new AutoValue_ProtoFile(this.filePath, this.packageName, this.syntax, Utils.immutableCopyOf(this.dependencies), Utils.immutableCopyOf(this.publicDependencies), Utils.immutableCopyOf(this.types), Utils.immutableCopyOf(this.services), Utils.immutableCopyOf(this.extendDeclarations), Utils.immutableCopyOf(this.options));
        }
    }

    public static enum Syntax {
        PROTO_2("proto2"),
        PROTO_3("proto3");

        private final String name;

        private Syntax(String name) {
            this.name = name;
        }
    }
}

