/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public abstract class RetryOnFailureOperation<T>
extends HotRodOperation<T>
implements ChannelOperation {
    protected static final Log log = LogFactory.getLog(RetryOnFailureOperation.class, Log.class);
    protected static final boolean trace = log.isTraceEnabled();
    private int retryCount = 0;
    private Set<SocketAddress> failedServers = null;
    private boolean triedCompleteRestart = false;
    private String currentClusterName;

    protected RetryOnFailureOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(requestCode, responseCode, codec, flags, cfg, cacheName, topologyId, channelFactory);
    }

    @Override
    public CompletableFuture<T> execute() {
        assert (!this.isDone());
        this.currentClusterName = this.channelFactory.getCurrentClusterName();
        if (trace) {
            log.tracef("Requesting channel for operation %s", this);
        }
        this.fetchChannelAndInvoke(this.retryCount, this.failedServers);
        return this;
    }

    @Override
    public void invoke(Channel channel) {
        assert (channel.isActive());
        try {
            if (trace) {
                log.tracef("About to start executing operation %s on %s", this, channel);
            }
            this.executeOperation(channel);
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
        finally {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        if ((cause = this.handleException(cause, null, address)) != null) {
            this.completeExceptionally(cause);
        }
    }

    private void retryIfNotDone() {
        if (!this.isDone()) {
            this.reset();
            this.currentClusterName = this.channelFactory.getCurrentClusterName();
            this.fetchChannelAndInvoke(this.retryCount, this.failedServers);
        }
    }

    protected void reset() {
    }

    private Set<SocketAddress> updateFailedServers(SocketAddress address) {
        if (this.failedServers == null) {
            this.failedServers = new HashSet<SocketAddress>();
        }
        if (trace) {
            log.tracef("Add %s to failed servers", address);
        }
        this.failedServers.add(address);
        return this.failedServers;
    }

    @Override
    public void channelInactive(Channel channel) {
        if (this.isDone()) {
            return;
        }
        SocketAddress address = ChannelRecord.of(channel).getUnresolvedAddress();
        this.updateFailedServers(address);
        this.logAndRetryOrFail(log.connectionClosed(address, address), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        SocketAddress address = ctx == null ? null : ChannelRecord.of(ctx.channel()).getUnresolvedAddress();
        if ((cause = this.handleException(cause, ctx, address)) != null) {
            try {
                this.completeExceptionally(cause);
            }
            finally {
                if (ctx != null) {
                    if (trace) {
                        log.tracef(cause, "(1) Requesting %s close due to exception", ctx.channel());
                    }
                    ctx.close();
                }
            }
        }
    }

    protected Throwable handleException(Throwable cause, ChannelHandlerContext ctx, SocketAddress address) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof RemoteIllegalLifecycleStateException || cause instanceof IOException || cause instanceof TransportException) {
            if (address != null) {
                this.updateFailedServers(address);
            }
            if (ctx != null) {
                if (ctx.pipeline().get("header-decoder") != null) {
                    ctx.pipeline().remove("header-decoder");
                }
                if (trace) {
                    log.tracef(cause, "(2) Requesting %s close due to exception", ctx.channel());
                }
                ctx.close();
            }
            this.logAndRetryOrFail(cause, true);
            return null;
        }
        if (cause instanceof RemoteNodeSuspectException) {
            this.logAndRetryOrFail(cause, false);
            return null;
        }
        if (cause instanceof HotRodClientException && ((HotRodClientException)cause).isServerError()) {
            this.completeExceptionally(cause);
            return null;
        }
        return cause;
    }

    protected void logAndRetryOrFail(Throwable e, boolean canSwitchCluster) {
        if (this.retryCount < this.channelFactory.getMaxRetries() && this.channelFactory.getMaxRetries() >= 0) {
            if (trace) {
                log.tracef(e, "Exception encountered in %s. Retry %d out of %d", this, this.retryCount, this.channelFactory.getMaxRetries());
            }
            ++this.retryCount;
            this.retryIfNotDone();
        } else if (canSwitchCluster) {
            this.channelFactory.trySwitchCluster(this.currentClusterName, this.cacheName).whenComplete((status, throwable) -> {
                if (throwable != null) {
                    this.completeExceptionally((Throwable)throwable);
                    return;
                }
                switch (status) {
                    case SWITCHED: {
                        this.triedCompleteRestart = true;
                        this.retryCount = 0;
                        break;
                    }
                    case NOT_SWITCHED: {
                        if (!this.triedCompleteRestart) {
                            log.debug("Cluster might have completely shut down, try resetting transport layer and topology id", e);
                            this.channelFactory.reset(this.cacheName);
                            this.triedCompleteRestart = true;
                            this.retryCount = 0;
                            break;
                        }
                        log.exceptionAndNoRetriesLeft(this.retryCount, this.channelFactory.getMaxRetries(), e);
                        this.completeExceptionally(e);
                        break;
                    }
                    case IN_PROGRESS: {
                        log.trace("Cluster switch in progress, retry operation without increasing retry count");
                        break;
                    }
                    default: {
                        this.completeExceptionally(new IllegalStateException("Unknown cluster switch status: " + (Object)status));
                    }
                }
                this.retryIfNotDone();
            });
        } else {
            log.exceptionAndNoRetriesLeft(this.retryCount, this.channelFactory.getMaxRetries(), e);
            this.completeExceptionally(e);
        }
    }

    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.channelFactory.fetchChannelAndInvoke(failedServers, this.cacheName, this);
    }

    protected abstract void executeOperation(Channel var1);
}

