/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.CredentialSourceDependency;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnManagerServiceNameProvider;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceNameProvider;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSessionFactory;
import org.wildfly.security.http.util.sso.SingleSignOnManager;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.password.interfaces.ClearPassword;

public class SingleSignOnSessionFactoryBuilder
extends SingleSignOnSessionFactoryServiceNameProvider
implements ResourceServiceBuilder<SingleSignOnSessionFactory>,
Value<SingleSignOnSessionFactory> {
    private final ValueDependency<SingleSignOnManager> manager;
    private volatile ValueDependency<KeyStore> keyStore;
    private volatile ValueDependency<SSLContext> sslContext;
    private volatile ValueDependency<CredentialSource> credentialSource;
    private volatile String keyAlias;

    public SingleSignOnSessionFactoryBuilder(String securityDomainName) {
        super(securityDomainName);
        this.manager = new InjectedValueDependency((ServiceNameProvider)new SingleSignOnManagerServiceNameProvider(securityDomainName), SingleSignOnManager.class);
    }

    public Builder<SingleSignOnSessionFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String keyStore = ApplicationSecurityDomainSingleSignOnDefinition.Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keyStore = new InjectedValueDependency(CommonUnaryRequirement.KEY_STORE.getServiceName(context, keyStore), KeyStore.class);
        this.keyAlias = ApplicationSecurityDomainSingleSignOnDefinition.Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.credentialSource = new CredentialSourceDependency(context, (Attribute)ApplicationSecurityDomainSingleSignOnDefinition.Attribute.CREDENTIAL, model);
        Optional sslContext = ModelNodes.optionalString((ModelNode)ApplicationSecurityDomainSingleSignOnDefinition.Attribute.SSL_CONTEXT.resolveModelAttribute((ExpressionResolver)context, model));
        this.sslContext = sslContext.map(value -> new InjectedValueDependency(CommonUnaryRequirement.SSL_CONTEXT.getServiceName(context, value), SSLContext.class)).orElse(null);
        return this;
    }

    public ServiceBuilder<SingleSignOnSessionFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this));
        Stream.of(this.manager, this.keyStore, this.credentialSource, this.sslContext).filter(Objects::nonNull).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public SingleSignOnSessionFactory getValue() {
        KeyStore store = (KeyStore)this.keyStore.getValue();
        String alias = this.keyAlias;
        CredentialSource source = (CredentialSource)this.credentialSource.getValue();
        try {
            ClearPassword password;
            PasswordCredential credential;
            if (!store.containsAlias(alias)) {
                UndertowLogger.ROOT_LOGGER.missingKeyStoreEntry(alias);
            }
            if (!store.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                UndertowLogger.ROOT_LOGGER.keyStoreEntryNotPrivate(alias);
            }
            if ((credential = (PasswordCredential)source.getCredential(PasswordCredential.class)) == null) {
                UndertowLogger.ROOT_LOGGER.missingCredential(source.toString());
            }
            if ((password = (ClearPassword)credential.getPassword(ClearPassword.class)) == null) {
                UndertowLogger.ROOT_LOGGER.credentialNotClearPassword(credential.toString());
            }
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)store.getEntry(alias, new KeyStore.PasswordProtection(password.getPassword()));
            KeyPair keyPair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
            Optional<SSLContext> context = Optional.ofNullable(this.sslContext).map(dependency -> (SSLContext)dependency.getValue());
            return new DefaultSingleSignOnSessionFactory((SingleSignOnManager)this.manager.getValue(), keyPair, connection -> context.ifPresent(ctx -> connection.setSSLSocketFactory(ctx.getSocketFactory())));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

