/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.weak;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.util.ByteString;

public class WeakCounterKey
implements CounterKey {
    public static final AdvancedExternalizer<WeakCounterKey> EXTERNALIZER = new Externalizer();
    private final ByteString counterName;
    private final int index;

    WeakCounterKey(ByteString counterName, int index) {
        this.counterName = Objects.requireNonNull(counterName);
        this.index = WeakCounterKey.requirePositive(index);
    }

    private static int requirePositive(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Requires positive index");
        }
        return i;
    }

    int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeakCounterKey that = (WeakCounterKey)o;
        return this.index == that.index && this.counterName.equals((Object)that.counterName);
    }

    public int hashCode() {
        int result = this.counterName.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public String toString() {
        return "WeakCounterKey{counterName=" + this.counterName + ", index=" + this.index + '}';
    }

    @Override
    public ByteString getCounterName() {
        return this.counterName;
    }

    private static class Externalizer
    implements AdvancedExternalizer<WeakCounterKey> {
        private Externalizer() {
        }

        public Set<Class<? extends WeakCounterKey>> getTypeClasses() {
            return Collections.singleton(WeakCounterKey.class);
        }

        public Integer getId() {
            return ExternalizerIds.WEAK_COUNTER_KEY;
        }

        public void writeObject(ObjectOutput output, WeakCounterKey object) throws IOException {
            ByteString.writeObject((ObjectOutput)output, (ByteString)object.counterName);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.index);
        }

        public WeakCounterKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new WeakCounterKey(ByteString.readObject((ObjectInput)input), UnsignedNumeric.readUnsignedInt((ObjectInput)input));
        }
    }
}

