/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.security.manager.DeploymentPermissionsResourceDefinition;
import org.wildfly.extension.security.manager.logging.SecurityManagerLogger;

public class SecurityManagerExtensionTransformerRegistration
implements ExtensionTransformerRegistration {
    private static final ModelVersion EAP_7_0_0_MODEL_VERSION = ModelVersion.create((int)2, (int)0, (int)0);

    public String getSubsystemName() {
        return "security-manager";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.addChildResource(DeploymentPermissionsResourceDefinition.DEPLOYMENT_PERMISSIONS_PATH).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode value, TransformationContext context) {
                return value.isDefined() && value.asList().isEmpty();
            }

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return SecurityManagerLogger.ROOT_LOGGER.rejectedEmptyMaximumSet();
            }
        }, new AttributeDefinition[]{DeploymentPermissionsResourceDefinition.MAXIMUM_PERMISSIONS});
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemTransformerRegistration)subsystemRegistration, (ModelVersionRange)EAP_7_0_0_MODEL_VERSION);
    }
}

