/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.Sessions;

public class SessionListenerBuilder
implements CapabilityServiceBuilder<SessionListener>,
Value<SessionListener>,
SessionListener {
    private final ServiceName name;
    private final ValueDependency<SSOManager> manager;

    public SessionListenerBuilder(ServiceName name, ValueDependency<SSOManager> manager) {
        this.name = name;
        this.manager = manager;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public SessionListener getValue() {
        return this;
    }

    public ServiceBuilder<SessionListener> build(ServiceTarget target) {
        return this.manager.register(target.addService(this.getServiceName(), (Service)new ValueService((Value)this)));
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        SSOManager manager = (SSOManager)this.manager.getValue();
        try (Batch batch = manager.getBatcher().createBatch();){
            Sessions sessions = manager.findSessionsContaining((Object)oldSessionId);
            if (sessions != null) {
                String deployment = sessions.getDeployments().stream().filter(key -> sessions.getSession(key) != null).findFirst().get();
                sessions.removeSession((Object)deployment);
                sessions.addSession((Object)deployment, (Object)session.getId());
            }
        }
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }
}

