/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class DiagnosticsHandler
implements Runnable {
    public static final String THREAD_NAME = "DiagnosticsHandler";
    protected TP transport;
    protected Thread thread;
    protected MulticastSocket diag_sock;
    protected InetAddress diagnostics_addr;
    protected int diagnostics_port = 7500;
    protected int ttl = 8;
    protected List<NetworkInterface> bind_interfaces;
    protected final Set<ProbeHandler> handlers = new CopyOnWriteArraySet<ProbeHandler>();
    protected final Log log;
    protected final SocketFactory socket_factory;
    protected final ThreadFactory thread_factory;
    protected final String passcode;

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, Log log, SocketFactory socket_factory, ThreadFactory thread_factory) {
        this(diagnostics_addr, diagnostics_port, log, socket_factory, thread_factory, null);
    }

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, Log log, SocketFactory socket_factory, ThreadFactory thread_factory, String passcode) {
        this.diagnostics_addr = diagnostics_addr;
        this.diagnostics_port = diagnostics_port;
        this.log = log;
        this.socket_factory = socket_factory;
        this.thread_factory = thread_factory;
        this.passcode = passcode;
    }

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, List<NetworkInterface> bind_interfaces, int diagnostics_ttl, Log log, SocketFactory socket_factory, ThreadFactory thread_factory, String passcode) {
        this(diagnostics_addr, diagnostics_port, log, socket_factory, thread_factory, passcode);
        this.bind_interfaces = bind_interfaces;
        this.ttl = diagnostics_ttl;
    }

    public TP transport() {
        return this.transport;
    }

    public DiagnosticsHandler transport(TP tp) {
        this.transport = tp;
        return this;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Set<ProbeHandler> getProbeHandlers() {
        return this.handlers;
    }

    public void registerProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    public void unregisterProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void start() throws IOException {
        this.diag_sock = this.socket_factory.createMulticastSocket("jgroups.tp.diag.mcast_sock", this.diagnostics_port);
        this.diag_sock.setTimeToLive(this.ttl);
        List<NetworkInterface> interfaces = this.bind_interfaces != null ? this.bind_interfaces : Util.getAllAvailableInterfaces();
        this.bindToInterfaces(interfaces, this.diag_sock);
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = this.thread_factory.newThread(this, THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void stop() {
        Thread tmp = this.thread;
        this.thread = null;
        if (this.diag_sock != null) {
            this.socket_factory.close(this.diag_sock);
        }
        if (tmp != null) {
            try {
                tmp.join(300L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive() && this.diag_sock != null && !this.diag_sock.isClosed();
    }

    @Override
    public void run() {
        while (Thread.currentThread().equals(this.thread)) {
            byte[] buf = new byte[10000];
            DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
            try {
                this.diag_sock.receive(packet);
                int payloadStartOffset = 0;
                if (this.isAuthorizationRequired()) {
                    payloadStartOffset = this.authorizeProbeRequest(packet);
                }
                this.handleDiagnosticProbe(packet.getSocketAddress(), this.diag_sock, new String(packet.getData(), packet.getOffset() + payloadStartOffset, packet.getLength()));
            }
            catch (IOException socket_ex) {
            }
            catch (Throwable e) {
                this.log.error(Util.getMessage("FailureHandlingDiagnosticsRequest"), e);
            }
        }
    }

    protected void handleDiagnosticProbe(SocketAddress sender, DatagramSocket sock, String request) {
        StringTokenizer tok = new StringTokenizer(request);
        ArrayList<String> list = new ArrayList<String>(10);
        while (tok.hasMoreTokens()) {
            String req = tok.nextToken().trim();
            if (req.isEmpty()) continue;
            if (req.startsWith("cluster=")) {
                if (this.sameCluster(req)) continue;
                return;
            }
            list.add(req);
        }
        if (list.isEmpty()) {
            Address local_addr = this.transport.localAddress();
            String default_rsp = String.format("local_addr=%s [%s]\nphysical_addr=%s\nview=%s\ncluster=%s\nversion=%s", local_addr != null ? local_addr : "n/a", local_addr != null ? ((UUID)local_addr).toStringLong() : "n/a", this.transport.getLocalPhysicalAddress(), this.transport.view(), this.transport.getClusterName(), Version.description);
            this.sendResponse(sock, sender, default_rsp.getBytes());
            return;
        }
        String[] tokens = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tokens[i] = (String)list.get(i);
        }
        for (ProbeHandler handler : this.handlers) {
            Map<String, String> map = null;
            try {
                map = handler.handleProbe(tokens);
            }
            catch (IllegalArgumentException ex) {
                this.log.warn(ex.getMessage());
                return;
            }
            if (map == null || map.isEmpty()) continue;
            StringBuilder info = new StringBuilder(this.defaultHeaders());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                info.append(String.format("%s=%s\r\n", entry.getKey(), entry.getValue()));
            }
            byte[] diag_rsp = info.toString().getBytes();
            this.log.debug("sending diag response to %s", sender);
            this.sendResponse(sock, sender, diag_rsp);
        }
    }

    protected String defaultHeaders() {
        Address local_addr = this.transport.localAddress();
        View view = this.transport.view();
        int num_members = view != null ? view.size() : 0;
        return String.format("local_addr=%s [ip=%s, version=%s, cluster=%s, %d mbr(s)]\n", local_addr != null ? local_addr : "n/a", this.transport.getLocalPhysicalAddress(), Version.description, this.transport.getClusterName(), num_members);
    }

    protected boolean sameCluster(String req) {
        if (!req.startsWith("cluster=")) {
            return true;
        }
        String cluster_name_pattern = req.substring("cluster=".length()).trim();
        if (!this.transport.isSingleton()) {
            String cname = this.transport.getClusterName();
            if (cluster_name_pattern != null && !Util.patternMatch(cluster_name_pattern, cname != null ? cname : null)) {
                this.log.debug("Probe request dropped as cluster name %s does not match pattern %s", cname, cluster_name_pattern);
                return false;
            }
            return true;
        }
        if (this.transport.getUpProtocols() != null) {
            boolean match = false;
            ArrayList<String> cnames = new ArrayList<String>();
            for (Protocol prot : this.transport.getUpProtocols().values()) {
                if (!(prot instanceof TP.ProtocolAdapter)) continue;
                cnames.add(((TP.ProtocolAdapter)prot).getClusterName());
            }
            for (String cname : cnames) {
                if (!Util.patternMatch(cluster_name_pattern, cname)) continue;
                match = true;
                break;
            }
            if (!match) {
                this.log.debug("Probe request dropped as cluster names %s do not match pattern %s", cnames, cluster_name_pattern);
                return false;
            }
        }
        return true;
    }

    protected int authorizeProbeRequest(DatagramPacket packet) throws Exception {
        int offset = 0;
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData());
        DataInputStream in = new DataInputStream(bis);
        long t1 = in.readLong();
        double q1 = in.readDouble();
        int length = in.readInt();
        byte[] digest = new byte[length];
        in.readFully(digest);
        offset = 20 + digest.length;
        byte[] local = Util.createDigest(this.passcode, t1, q1);
        if (!MessageDigest.isEqual(digest, local)) {
            throw new Exception("Authorization failed! Make sure correct passcode is used");
        }
        this.log.debug("Request authorized");
        return offset;
    }

    protected void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) {
        try {
            DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
            sock.send(p);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingDiagRspTo") + sender, t);
        }
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s) {
        InetSocketAddress group_addr = new InetSocketAddress(this.diagnostics_addr, this.diagnostics_port);
        for (NetworkInterface i : interfaces) {
            try {
                List<InterfaceAddress> inet_addrs;
                if (!i.isUp() || (inet_addrs = i.getInterfaceAddresses()) == null || inet_addrs.isEmpty()) continue;
                s.joinGroup(group_addr, i);
                this.log.trace("joined %s on %s", group_addr, i.getName());
            }
            catch (Exception e) {
                this.log.warn("failed to join " + group_addr + " on " + i.getName() + ": " + e);
            }
        }
    }

    protected boolean isAuthorizationRequired() {
        return this.passcode != null;
    }

    public static interface ProbeHandler {
        public Map<String, String> handleProbe(String ... var1);

        public String[] supportedKeys();
    }
}

