/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientResponse;
import java.io.IOException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.httpclient.common.ContentType;

@MessageLogger(projectCode="WFHTTP")
interface HttpClientMessages
extends BasicLogger {
    public static final HttpClientMessages MESSAGES = Logger.getMessageLogger(HttpClientMessages.class, HttpClientMessages.class.getPackage().getName());

    @Message(id=2, value="Port value %s out of range")
    public ConfigXMLParseException portValueOutOfRange(int var1);

    @Message(id=3, value="Failed to acquire session")
    @LogMessage(level=Logger.Level.ERROR)
    public void failedToAcquireSession(@Cause Throwable var1);

    @Message(id=4, value="Invalid response type %s")
    public IOException invalidResponseType(ContentType var1);

    @Message(id=5, value="Invalid response code %s (full response %s)")
    public IOException invalidResponseCode(int var1, ClientResponse var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to write exception")
    public void failedToWriteException(@Cause Exception var1);

    @Message(id=7, value="Invalid content encoding %s")
    public IOException invalidContentEncoding(String var1);

    @Message(id=8, value="Authentication failed")
    public SecurityException authenticationFailed();

    @Message(id=9, value="Unsupported qop version in digest auth")
    public RuntimeException unsupportedQopInDigest();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Error parsing authentication-info header")
    public void failedToParseAuthenticationInfo(@Cause Exception var1);

    @Message(id=11, value="Stream is closed")
    public IOException streamIsClosed();

    @Message(id=12, value="Attempted to do blocking IO from the IO thread. This is prohibited as it may result in deadlocks")
    public IllegalStateException blockingIoFromIOThread();
}

