/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class GeoHashGridAggregation
extends BucketAggregation {
    public static final String TYPE = "geohash_grid";
    private List<GeoHashGrid> geoHashGrids = new LinkedList<GeoHashGrid>();

    public GeoHashGridAggregation(String name, JsonObject geohashGridAggregation) {
        super(name, geohashGridAggregation);
        if (geohashGridAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && geohashGridAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(geohashGridAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketElement : bucketsSource) {
            JsonObject bucket = bucketElement.getAsJsonObject();
            GeoHashGrid geoHashGrid = new GeoHashGrid(bucket, bucket.get(String.valueOf((Object)AggregationField.KEY)).getAsString(), (Long)bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong());
            this.geoHashGrids.add(geoHashGrid);
        }
    }

    public List<GeoHashGrid> getBuckets() {
        return this.geoHashGrids;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GeoHashGridAggregation rhs = (GeoHashGridAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.geoHashGrids, rhs.geoHashGrids).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.geoHashGrids).toHashCode();
    }

    public static class GeoHashGrid
    extends Bucket {
        private String key;

        public GeoHashGrid(JsonObject bucket, String key, Long count) {
            super(bucket, count);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            GeoHashGrid rhs = (GeoHashGrid)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.key, (Object)rhs.key).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.key).toHashCode();
        }
    }
}

