/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.VersionedDecoder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.TimeoutException;

public class Decoder10
implements VersionedDecoder {
    private static final Log log = (Log)LogFactory.getLog(Decoder10.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();

    @Override
    public boolean readHeader(ByteBuf buffer, byte version, long messageId, HotRodHeader header) throws Exception {
        if (header.op == null) {
            Optional<Byte> maybeByte = ExtendedByteBuf.readMaybeByte(buffer);
            if (!maybeByte.flatMap(streamOp -> ExtendedByteBuf.readMaybeString(buffer).map(cacheName -> {
                header.op = HotRodOperation.fromRequestOpCode(streamOp);
                if (isTrace) {
                    log.tracef("Operation code: %d has been matched to %s", streamOp, (Object)header.op);
                }
                header.cacheName = cacheName;
                buffer.markReaderIndex();
                return streamOp;
            })).isPresent()) {
                return false;
            }
            if (header.op == null) {
                throw new HotRodUnknownOperationException("Unknown operation: " + maybeByte.get(), version, messageId);
            }
        }
        return ExtendedByteBuf.readMaybeVInt(buffer).flatMap(flag -> ExtendedByteBuf.readMaybeByte(buffer).flatMap(clientIntelligence -> ExtendedByteBuf.readMaybeVInt(buffer).flatMap(topologyId -> ExtendedByteBuf.readMaybeByte(buffer).map(txId -> {
            if (txId != 0) {
                throw new UnsupportedOperationException("Transaction types other than 0 (NO_TX) is not supported at this stage.  Saw TX_ID of " + txId);
            }
            header.flag = flag;
            header.clientIntel = clientIntelligence.byteValue();
            header.topologyId = topologyId;
            buffer.markReaderIndex();
            return txId;
        })))).isPresent();
    }

    @Override
    public CacheDecodeContext.RequestParameters readParameters(HotRodHeader header, ByteBuf buffer) {
        switch (header.op) {
            case REMOVE_IF_UNMODIFIED: {
                return ExtendedByteBuf.readMaybeLong(buffer).map(l -> new CacheDecodeContext.RequestParameters(-1, new CacheDecodeContext.ExpirationParam(-1L, TimeUnitValue.SECONDS), new CacheDecodeContext.ExpirationParam(-1L, TimeUnitValue.SECONDS), (long)l)).orElse(null);
            }
            case REPLACE_IF_UNMODIFIED: {
                return this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag.DefaultLifespan)).flatMap(lifespan -> this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag.DefaultMaxIdle)).flatMap(maxIdle -> ExtendedByteBuf.readMaybeLong(buffer).flatMap(version -> ExtendedByteBuf.readMaybeVInt(buffer).map(valueLength -> new CacheDecodeContext.RequestParameters((int)valueLength, new CacheDecodeContext.ExpirationParam(lifespan.intValue(), TimeUnitValue.SECONDS), new CacheDecodeContext.ExpirationParam(maxIdle.intValue(), TimeUnitValue.SECONDS), (long)version))))).orElse(null);
            }
        }
        return this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag.DefaultLifespan)).flatMap(lifespan -> this.readLifespanOrMaxIdle(buffer, this.hasFlag(header, ProtocolFlag.DefaultMaxIdle)).flatMap(maxIdle -> ExtendedByteBuf.readMaybeVInt(buffer).map(valueLength -> new CacheDecodeContext.RequestParameters((int)valueLength, new CacheDecodeContext.ExpirationParam(lifespan.intValue(), TimeUnitValue.SECONDS), new CacheDecodeContext.ExpirationParam(maxIdle.intValue(), TimeUnitValue.SECONDS), -1L)))).orElse(null);
    }

    private boolean hasFlag(HotRodHeader h, ProtocolFlag f) {
        return (h.flag & f.getValue()) == f.getValue();
    }

    private Optional<Integer> readLifespanOrMaxIdle(ByteBuf buffer, boolean useDefault) {
        return ExtendedByteBuf.readMaybeVInt(buffer).map(stream -> {
            if (stream <= 0) {
                if (useDefault) {
                    return -2;
                }
                return -1;
            }
            return stream;
        });
    }

    @Override
    public Response createSuccessResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationStatus.Success, prev);
    }

    @Override
    public Response createNotExecutedResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationStatus.OperationNotExecuted, prev);
    }

    @Override
    public Response createNotExistResponse(HotRodHeader header) {
        return this.createResponse(header, OperationStatus.KeyDoesNotExist, null);
    }

    private Response createResponse(HotRodHeader h, OperationStatus st, byte[] prev) {
        if (this.hasFlag(h, ProtocolFlag.ForceReturnPreviousValue)) {
            return new ResponseWithPrevious(h.version, h.messageId, h.cacheName, h.clientIntel, h.op, st, h.topologyId, Optional.ofNullable(prev));
        }
        return new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.op, st, h.topologyId);
    }

    @Override
    public Response createGetResponse(HotRodHeader h, CacheEntry<byte[], byte[]> entry) {
        HotRodOperation op = h.op;
        if (entry != null && op == HotRodOperation.GET) {
            return new GetResponse(h.version, h.messageId, h.cacheName, h.clientIntel, op, OperationStatus.Success, h.topologyId, (byte[])entry.getValue());
        }
        if (entry != null && op == HotRodOperation.GET_WITH_VERSION) {
            long version = ((NumericVersion)entry.getMetadata().version()).getVersion();
            return new GetWithVersionResponse(h.version, h.messageId, h.cacheName, h.clientIntel, op, OperationStatus.Success, h.topologyId, (byte[])entry.getValue(), version);
        }
        if (op == HotRodOperation.GET) {
            return new GetResponse(h.version, h.messageId, h.cacheName, h.clientIntel, op, OperationStatus.KeyDoesNotExist, h.topologyId, null);
        }
        return new GetWithVersionResponse(h.version, h.messageId, h.cacheName, h.clientIntel, op, OperationStatus.KeyDoesNotExist, h.topologyId, null, 0L);
    }

    @Override
    public void customReadHeader(HotRodHeader header, ByteBuf buffer, CacheDecodeContext hrCtx, List<Object> out) {
    }

    @Override
    public void customReadKey(HotRodHeader h, ByteBuf buffer, CacheDecodeContext hrCtx, List<Object> out) {
        switch (h.op) {
            case BULK_GET: 
            case BULK_GET_KEYS: {
                Optional<Integer> number = ExtendedByteBuf.readMaybeVInt(buffer);
                number.ifPresent(n -> {
                    hrCtx.operationDecodeContext = n;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
                break;
            }
            case QUERY: {
                Optional<byte[]> bytes = ExtendedByteBuf.readMaybeRangedBytes(buffer);
                bytes.ifPresent(b -> {
                    hrCtx.operationDecodeContext = b;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
            }
        }
    }

    @Override
    public void customReadValue(HotRodHeader header, ByteBuf buffer, CacheDecodeContext hrCtx, List<Object> out) {
    }

    @Override
    public StatsResponse createStatsResponse(CacheDecodeContext hrCtx, Stats cacheStats, NettyTransport t) {
        HotRodHeader h = hrCtx.header;
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("timeSinceStart", String.valueOf(cacheStats.getTimeSinceStart()));
        stats.put("currentNumberOfEntries", String.valueOf(cacheStats.getCurrentNumberOfEntries()));
        stats.put("totalNumberOfEntries", String.valueOf(cacheStats.getTotalNumberOfEntries()));
        stats.put("stores", String.valueOf(cacheStats.getStores()));
        stats.put("retrievals", String.valueOf(cacheStats.getRetrievals()));
        stats.put("hits", String.valueOf(cacheStats.getHits()));
        stats.put("misses", String.valueOf(cacheStats.getMisses()));
        stats.put("removeHits", String.valueOf(cacheStats.getRemoveHits()));
        stats.put("removeMisses", String.valueOf(cacheStats.getRemoveMisses()));
        stats.put("totalBytesRead", t.getTotalBytesRead());
        stats.put("totalBytesWritten", t.getTotalBytesWritten());
        return new StatsResponse(h.version, h.messageId, h.cacheName, h.clientIntel, stats, h.topologyId);
    }

    @Override
    public ErrorResponse createErrorResponse(HotRodHeader header, Throwable t) {
        if (t instanceof IOException) {
            return new ErrorResponse(header.version, header.messageId, header.cacheName, header.clientIntel, OperationStatus.ParseError, header.topologyId, t.toString());
        }
        if (t instanceof TimeoutException) {
            return new ErrorResponse(header.version, header.messageId, header.cacheName, header.clientIntel, OperationStatus.OperationTimedOut, header.topologyId, t.toString());
        }
        return new ErrorResponse(header.version, header.messageId, header.cacheName, header.clientIntel, OperationStatus.ServerError, header.topologyId, t.toString());
    }

    @Override
    public AdvancedCache<byte[], byte[]> getOptimizedCache(HotRodHeader h, AdvancedCache<byte[], byte[]> c, Configuration cacheCfg) {
        if (!this.hasFlag(h, ProtocolFlag.ForceReturnPreviousValue)) {
            switch (h.op) {
                case PUT: 
                case PUT_IF_ABSENT: {
                    return c.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                }
            }
        }
        return c;
    }

    @Override
    public boolean isSkipCacheLoad(HotRodHeader header) {
        return false;
    }

    @Override
    public boolean isSkipIndexing(HotRodHeader header) {
        return false;
    }
}

