/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.concurrent.Executor;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.CacheRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.PrepareTransactionContext;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.TransactionResponse;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.CommitTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.PrepareTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.RollbackTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.SecondPhaseTransactionDecodeContext;
import org.infinispan.server.hotrod.tx.TxState;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.LogFactory;

class TransactionRequestProcessor
extends CacheRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(TransactionRequestProcessor.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();

    TransactionRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
    }

    void rollbackTransaction(CacheDecodeContext cdc) {
        this.validateConfiguration(cdc, cdc.cache());
        this.executor.execute(() -> this.rollbackTransactionInternal(cdc));
    }

    private void rollbackTransactionInternal(CacheDecodeContext cdc) {
        try {
            this.writeResponse(this.finishTransaction(cdc, new RollbackTransactionDecodeContext(cdc.cache(), (XidImpl)cdc.operationDecodeContext)));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void prepareTransaction(CacheDecodeContext cdc) {
        this.validateConfiguration(cdc, cdc.cache());
        this.executor.execute(() -> this.prepareTransactionInternal(cdc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTransactionInternal(CacheDecodeContext cdc) {
        try {
            AdvancedCache<byte[], byte[]> cache = cdc.cache();
            PrepareTransactionContext context = (PrepareTransactionContext)cdc.operationDecodeContext;
            if (context.isEmpty()) {
                if (isTrace) {
                    log.tracef("Transaction %s is read only.", context.getXid());
                }
                this.writeResponse(this.createTransactionResponse(cdc.header, 3));
                return;
            }
            PrepareTransactionDecodeContext txContext = new PrepareTransactionDecodeContext(cache, context.getXid());
            Response response = this.checkExistingTxForPrepare(cdc, txContext);
            if (response != null) {
                if (isTrace) {
                    log.tracef("Transaction %s conflicts with another node. Response is %s", context.getXid(), response);
                }
                this.writeResponse(response);
                return;
            }
            if (!txContext.startTransaction()) {
                if (isTrace) {
                    log.tracef("Unable to start transaction %s", context.getXid());
                }
                this.writeResponse(cdc.decoder.createNotExecutedResponse(cdc.header, null));
                return;
            }
            AdvancedCache<byte[], byte[]> txCache = txContext.decorateCache(cache);
            try {
                for (TransactionWrite write : context.writes()) {
                    if (this.isValid(write, txCache)) {
                        if (write.isRemove()) {
                            txCache.remove((Object)write.key);
                            continue;
                        }
                        txCache.put((Object)write.key, (Object)write.value, cdc.buildMetadata(write.lifespan, write.maxIdle));
                        continue;
                    }
                    txContext.setRollbackOnly();
                    break;
                }
                int xaCode = txContext.prepare(context.isOnePhaseCommit());
                this.writeResponse(this.createTransactionResponse(cdc.header, xaCode));
            }
            catch (Exception e) {
                this.writeResponse(this.createTransactionResponse(cdc.header, txContext.rollback()));
            }
            finally {
                EmbeddedTransactionManager.dissociateTransaction();
            }
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void commitTransaction(CacheDecodeContext cdc) {
        this.validateConfiguration(cdc, cdc.cache());
        this.executor.execute(() -> this.commitTransactionInternal(cdc));
    }

    private void commitTransactionInternal(CacheDecodeContext cdc) {
        try {
            this.writeResponse(this.finishTransaction(cdc, new CommitTransactionDecodeContext(cdc.cache(), (XidImpl)cdc.operationDecodeContext)));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    private TransactionResponse finishTransaction(CacheDecodeContext cdc, SecondPhaseTransactionDecodeContext txContext) {
        try {
            txContext.perform();
        }
        catch (HeuristicMixedException e) {
            return this.createTransactionResponse(cdc.header, 5);
        }
        catch (HeuristicRollbackException e) {
            return this.createTransactionResponse(cdc.header, 6);
        }
        catch (RollbackException e) {
            return this.createTransactionResponse(cdc.header, 100);
        }
        return this.createTransactionResponse(cdc.header, 0);
    }

    private void validateConfiguration(CacheDecodeContext cdc, AdvancedCache<byte[], byte[]> cache) {
        Configuration configuration = cache.getCacheConfiguration();
        if (!configuration.transaction().transactionMode().isTransactional()) {
            throw log.expectedTransactionalCache(cache.getName());
        }
        if (configuration.locking().isolationLevel() != IsolationLevel.REPEATABLE_READ) {
            throw log.unexpectedIsolationLevel(cache.getName());
        }
        if (configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC || configuration.transaction().transactionProtocol() == TransactionProtocol.TOTAL_ORDER) {
            throw new IllegalStateException(String.format("Cache '%s' cannot use Optimistic neither Total Order transactions.", cache.getName()));
        }
    }

    private Response checkExistingTxForPrepare(CacheDecodeContext cdc, PrepareTransactionDecodeContext context) {
        TxState txState = context.getTxState();
        if (txState == null) {
            return null;
        }
        switch (txState.status()) {
            case 0: {
                break;
            }
            case 2: {
                return this.createTransactionResponse(cdc.header, 0);
            }
            case 4: {
                return this.createTransactionResponse(cdc.header, 100);
            }
            case 3: {
                return this.createTransactionResponse(cdc.header, 0);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (context.isAlive(txState.getOriginator())) {
            return cdc.decoder.createNotExecutedResponse(cdc.header, null);
        }
        context.rollbackRemoteTransaction();
        return null;
    }

    private boolean isValid(TransactionWrite write, AdvancedCache<byte[], byte[]> readCache) {
        if (write.skipRead()) {
            if (isTrace) {
                log.tracef("Operation %s wasn't read.", write);
            }
            return true;
        }
        CacheEntry entry = readCache.getCacheEntry((Object)write.key);
        if (write.wasNonExisting()) {
            if (isTrace) {
                log.tracef("Key didn't exist for operation %s. Entry is %s", write, entry);
            }
            return entry == null || entry.getValue() == null;
        }
        if (isTrace) {
            log.tracef("Checking version for operation %s. Entry is %s", write, entry);
        }
        return entry != null && write.versionRead == MetadataUtils.extractVersion(entry);
    }

    private TransactionResponse createTransactionResponse(HotRodHeader header, int xaReturnCode) {
        return new TransactionResponse(header.version, header.messageId, header.cacheName, header.clientIntel, header.op, OperationStatus.Success, header.topologyId, xaReturnCode);
    }
}

