/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import javax.servlet.ServletContext;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class InfinispanSessionManagerFactory<C extends Marshallability>
implements SessionManagerFactory<TransactionBatch> {
    private final InfinispanSessionManagerFactoryConfiguration<C> config;

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration<C> config) {
        this.config = config;
    }

    public <L> SessionManager<L, TransactionBatch> createSessionManager(final SessionManagerConfiguration<L> configuration) {
        InfinispanBatcher batcher = new InfinispanBatcher(this.config.getCache());
        final Cache cache = this.config.getCache();
        InfinispanCacheProperties properties = new InfinispanCacheProperties(cache.getCacheConfiguration());
        AffinityIdentifierFactory factory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), cache, this.config.getKeyAffinityServiceFactory());
        CommandDispatcherFactory dispatcherFactory = this.config.getCommandDispatcherFactory();
        NodeFactory<Address> nodeFactory = this.config.getNodeFactory();
        int maxActiveSessions = this.config.getSessionManagerFactoryConfiguration().getMaxActiveSessions();
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration((CacheProperties)properties, factory, (Batcher)batcher, dispatcherFactory, nodeFactory, maxActiveSessions){
            final /* synthetic */ CacheProperties val$properties;
            final /* synthetic */ IdentifierFactory val$factory;
            final /* synthetic */ Batcher val$batcher;
            final /* synthetic */ CommandDispatcherFactory val$dispatcherFactory;
            final /* synthetic */ NodeFactory val$nodeFactory;
            final /* synthetic */ int val$maxActiveSessions;
            {
                this.val$properties = cacheProperties;
                this.val$factory = identifierFactory;
                this.val$batcher = batcher;
                this.val$dispatcherFactory = commandDispatcherFactory;
                this.val$nodeFactory = nodeFactory;
                this.val$maxActiveSessions = n;
            }

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Cache<Key<String>, ?> getCache() {
                return cache;
            }

            @Override
            public CacheProperties getProperties() {
                return this.val$properties;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return this.val$batcher;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$dispatcherFactory;
            }

            @Override
            public NodeFactory<Address> getNodeFactory() {
                return this.val$nodeFactory;
            }

            @Override
            public int getMaxActiveSessions() {
                return this.val$maxActiveSessions;
            }

            @Override
            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return configuration.getInactiveSessionRecorder();
            }
        };
        return new InfinispanSessionManager(this.createSessionFactory((CacheProperties)properties, configuration.getLocalContextFactory()), config);
    }

    private <L> SessionFactory<?, ?, L> createSessionFactory(CacheProperties properties, LocalContextFactory<L> localContextFactory) {
        InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(this.config.getCache(), properties);
        return new InfinispanSessionFactory(metaDataFactory, this.createSessionAttributesFactory(properties), localContextFactory);
    }

    private SessionAttributesFactory<?> createSessionAttributesFactory(CacheProperties properties) {
        SessionManagerFactoryConfiguration<C> config = this.config.getSessionManagerFactoryConfiguration();
        MarshalledValueFactory factory = config.getMarshalledValueFactory();
        Marshallability context = config.getMarshallingContext();
        switch (this.config.getSessionManagerFactoryConfiguration().getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory((Cache<SessionAttributeNamesKey, SessionAttributeNamesEntry>)this.config.getCache(), this.config.getCache(), new MarshalledValueMarshaller(factory, context), properties);
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(this.config.getCache(), new MarshalledValueMarshaller(factory, context), properties);
            }
        }
        throw new IllegalStateException();
    }
}

