/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class SHUFFLE
extends Protocol {
    protected TimeScheduler timer;
    protected List<Message> up_msgs;
    protected List<Message> down_msgs;
    protected final Lock up_lock = new ReentrantLock();
    protected final Lock down_lock = new ReentrantLock();
    protected Future<?> task;
    @Property(description="Reorder up messages and message batches")
    protected boolean up = true;
    @Property(description="Reorder down messages and message batches")
    protected boolean down;
    @Property(description="max number of messages before we reorder queued messages and send them up")
    protected int max_size = 10;
    @Property(description="max time (in millis) before we pass the reordered messages up or down")
    protected long max_time = 1500L;

    public boolean isUp() {
        return this.up;
    }

    public SHUFFLE setUp(boolean up2) {
        this.up = up2;
        return this;
    }

    public boolean isDown() {
        return this.down;
    }

    public SHUFFLE setDown(boolean down2) {
        this.down = down2;
        return this;
    }

    public int getMaxSize() {
        return this.max_size;
    }

    public SHUFFLE setMaxSize(int max_size) {
        this.max_size = max_size;
        return this;
    }

    public long getMaxTime() {
        return this.max_time;
    }

    public SHUFFLE setMaxTime(long max_time) {
        this.max_time = max_time;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
        this.up_msgs = new ArrayList<Message>(this.max_size);
        this.down_msgs = new ArrayList<Message>(this.max_size);
    }

    @Override
    public void stop() {
        super.stop();
        this.stopTask();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stopTask();
    }

    @Override
    public Object down(Message msg) {
        if (!this.down) {
            return this.down_prot.down(msg);
        }
        this.add(this.down_msgs, msg, this.down_lock, (Message m) -> this.down_prot.down((Message)m));
        return null;
    }

    @Override
    public Object up(Message msg) {
        if (!this.up) {
            return this.up_prot.up(msg);
        }
        this.add(this.up_msgs, msg, this.up_lock, (Message m) -> this.up_prot.up(msg));
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        if (!this.up) {
            this.up_prot.up(batch);
            return;
        }
        if (batch.size() > 1) {
            SHUFFLE.shuffle(batch);
            if (!batch.isEmpty()) {
                this.up_prot.up(batch);
            }
        } else {
            this.add(this.up_msgs, batch, this.up_lock, (Message m) -> this.up_prot.up((Message)m));
        }
    }

    protected static void shuffle(MessageBatch batch) {
        Message[] msgs = batch.array();
        Util.shuffle(msgs, 0, batch.index());
    }

    protected synchronized void startTask() {
        if (this.task == null || this.task.isDone() || this.task.isCancelled()) {
            this.task = this.timer.schedule(() -> {
                this.reorderAndSend(this.up_msgs, this.up_lock, msg -> this.up_prot.up((Message)msg));
                this.reorderAndSend(this.down_msgs, this.down_lock, msg -> this.down_prot.down((Message)msg));
            }, this.max_time, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopTask() {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SHUFFLE add(List<Message> queue, Message msg, Lock lock, Consumer<Message> send_function) {
        lock.lock();
        try {
            queue.add(msg);
            if (queue.size() >= this.max_size) {
                this.reorderAndSend(queue, lock, send_function);
            } else {
                this.startTask();
            }
            SHUFFLE sHUFFLE = this;
            return sHUFFLE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SHUFFLE add(List<Message> queue, MessageBatch batch, Lock lock, Consumer<Message> send_function) {
        lock.lock();
        try {
            for (Message msg : batch) {
                queue.add(msg);
            }
            if (queue.size() >= this.max_size) {
                this.reorderAndSend(queue, lock, send_function);
            }
            SHUFFLE sHUFFLE = this;
            return sHUFFLE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SHUFFLE reorderAndSend(List<Message> list, Lock lock, Consumer<Message> send_function) {
        lock.lock();
        try {
            Collections.shuffle(list);
            list.forEach(send_function);
            list.clear();
            SHUFFLE sHUFFLE = this;
            return sHUFFLE;
        }
        finally {
            lock.unlock();
        }
    }
}

