/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.net.URI;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.ConfiguredProvider;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.ServicesQueue;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;

public final class Discovery
implements Contextual<Discovery> {
    private static final Logger log = Logger.getLogger((String)"org.wildfly.discovery");
    private static final ServiceURL END_MARK = new ServiceURL.Builder().setUri(URI.create("DUMMY:DUMMY")).create();
    private static final ContextManager<Discovery> CONTEXT_MANAGER = new ContextManager(Discovery.class, "org.wildfly.discovery");
    private final DiscoveryProvider provider;

    Discovery(DiscoveryProvider provider) {
        this.provider = provider;
    }

    public ContextManager<Discovery> getInstanceContextManager() {
        return CONTEXT_MANAGER;
    }

    public static ContextManager<Discovery> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public ServicesQueue discover(ServiceType serviceType, FilterSpec filterSpec) {
        Assert.checkNotNullParam((String)"serviceType", (Object)serviceType);
        LinkedBlockingQueue<ServiceURL> queue = new LinkedBlockingQueue<ServiceURL>();
        CopyOnWriteArrayList<Throwable> problems = new CopyOnWriteArrayList<Throwable>();
        BlockingQueueDiscoveryResult result = new BlockingQueueDiscoveryResult(queue, problems);
        log.tracef("Calling discover(%s, %s) with result instance %s\n", (Object)serviceType, (Object)filterSpec, (Object)result);
        return new BlockingQueueServicesQueue(queue, problems, this.provider.discover(serviceType, filterSpec, result));
    }

    public static Discovery create(DiscoveryProvider ... providers) {
        Assert.checkNotNullParam((String)"providers", (Object)providers);
        DiscoveryProvider[] clone = (DiscoveryProvider[])providers.clone();
        int length = clone.length;
        for (int i = 0; i < length; ++i) {
            Assert.checkNotNullArrayParam((String)"providers", (int)i, (Object)clone[i]);
        }
        if (clone.length == 0) {
            return new Discovery(DiscoveryProvider.EMPTY);
        }
        if (clone.length == 1) {
            return new Discovery(clone[0]);
        }
        return new Discovery(new AggregateDiscoveryProvider(clone));
    }

    public static Discovery create(DiscoveryProvider provider) {
        Assert.checkNotNullParam((String)"provider", (Object)provider);
        return new Discovery(provider);
    }

    static {
        CONTEXT_MANAGER.setGlobalDefaultSupplier(() -> Discovery.create((DiscoveryProvider)ConfiguredProvider.INSTANCE));
    }

    static final class BlockingQueueServicesQueue
    implements ServicesQueue {
        private final LinkedBlockingQueue<ServiceURL> queue;
        private final CopyOnWriteArrayList<Throwable> problems;
        private final DiscoveryRequest request;
        private ServiceURL next;
        private boolean done;

        BlockingQueueServicesQueue(LinkedBlockingQueue<ServiceURL> queue, CopyOnWriteArrayList<Throwable> problems, DiscoveryRequest request) {
            this.queue = queue;
            this.problems = problems;
            this.request = request;
        }

        @Override
        public void await() throws InterruptedException {
            if (this.done) {
                return;
            }
            while (this.next == null) {
                this.next = this.queue.take();
                if (this.next != END_MARK) continue;
                this.next = null;
                this.done = true;
                return;
            }
        }

        @Override
        public void await(long time, TimeUnit unit) throws InterruptedException {
            long now;
            long mark = System.nanoTime();
            for (long remaining = unit.toNanos(time); this.next == null && !this.done && remaining > 0L; remaining -= Math.max(1L, now - mark)) {
                this.next = this.queue.poll(remaining, TimeUnit.NANOSECONDS);
                now = System.nanoTime();
                if (this.next != END_MARK) continue;
                this.next = null;
                this.done = true;
                return;
            }
        }

        @Override
        public boolean isReady() {
            return this.next != null || this.done;
        }

        @Override
        public ServiceURL pollService() {
            try {
                ServiceURL serviceURL = this.next;
                return serviceURL;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public ServiceURL takeService() throws InterruptedException {
            this.await();
            return this.pollService();
        }

        @Override
        public boolean isFinished() {
            return this.next == null && this.done;
        }

        @Override
        public void close() {
            if (!this.isFinished()) {
                this.request.cancel();
            }
        }

        @Override
        @NotNull
        public List<Throwable> getProblems() {
            return this.problems;
        }
    }

    static final class BlockingQueueDiscoveryResult
    implements DiscoveryResult {
        private final AtomicBoolean done = new AtomicBoolean(false);
        private final BlockingQueue<ServiceURL> queue;
        private final CopyOnWriteArrayList<Throwable> problems;

        BlockingQueueDiscoveryResult(BlockingQueue<ServiceURL> queue, CopyOnWriteArrayList<Throwable> problems) {
            this.queue = queue;
            this.problems = problems;
        }

        @Override
        public void complete() {
            if (this.done.compareAndSet(false, true)) {
                this.queue.add(END_MARK);
                log.tracef("Discovery complete on %s\n", (Object)this);
            }
        }

        @Override
        public void reportProblem(Throwable description) {
            Assert.checkNotNullParam((String)"description", (Object)description);
            this.problems.add(description);
            log.tracef(description, "Reported problem on %s", (Object)this);
        }

        @Override
        public void addMatch(ServiceURL serviceURL) {
            if (serviceURL != null && !this.done.get()) {
                log.tracef("Adding service URL match \"%s\" to %s", (Object)serviceURL, (Object)this);
                this.queue.offer(serviceURL);
            } else {
                log.tracef("Ignoring service URL match \"%s\" to %s", (Object)serviceURL, (Object)this);
            }
        }
    }
}

