/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemRootResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLReader;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLWriter;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;

public class InfinispanExtension
implements Extension {
    public static final String MODULE_NAME = "org.infinispan.extension";
    public static final String SUBSYSTEM_NAME = "datagrid-infinispan";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"datagrid-infinispan");

    public void initialize(ExtensionContext context) {
        PathManager pathManager;
        ResolvePathHandler resolvePathHandler;
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, Namespace.CURRENT.getVersion());
        if (context.getProcessType().isServer()) {
            resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)FileStoreResource.PATH).setRelativeToAttribute((AttributeDefinition)FileStoreResource.RELATIVE_TO).build();
            pathManager = context.getPathManager();
        } else {
            resolvePathHandler = null;
            pathManager = null;
        }
        subsystem.registerSubsystemModel((ResourceDefinition)InfinispanSubsystemRootResource.create(resolvePathHandler, pathManager, context.isRuntimeOnlyRegistrationValid()));
        subsystem.registerXMLElementWriter(InfinispanSubsystemXMLWriter::new);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), () -> new InfinispanSubsystemXMLReader(namespace));
        }
    }
}

