/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.UUID;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.infinispan.util.InvocationAfterCompletion;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.infinispan.AdvancedCache;

public class FutureUpdateSynchronization
extends InvocationAfterCompletion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(FutureUpdateSynchronization.class);
    private final UUID uuid = UUID.randomUUID();
    private final Object key;
    private final Object value;
    private final BaseTransactionalDataRegion region;
    private final long sessionTimestamp;
    private final AdvancedCache cache;

    public FutureUpdateSynchronization(TransactionCoordinator tc, AdvancedCache cache, boolean requiresTransaction, Object key, Object value, BaseTransactionalDataRegion region, long sessionTimestamp) {
        super(tc, requiresTransaction);
        this.cache = cache;
        this.key = key;
        this.value = value;
        this.region = region;
        this.sessionTimestamp = sessionTimestamp;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    protected void invoke(boolean success) {
        if (this.sessionTimestamp < this.region.getLastRegionInvalidation()) {
            success = false;
        }
        FutureUpdate futureUpdate = new FutureUpdate(this.uuid, this.region.nextTimestamp(), success ? this.value : null);
        while (true) {
            try {
                this.cache.put(this.key, (Object)futureUpdate);
                return;
            }
            catch (Exception e) {
                log.failureInAfterCompletion(e);
                continue;
            }
            break;
        }
    }
}

