/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;

public class ClusterConnectionControlImpl
extends AbstractControl
implements ClusterConnectionControl {
    private final ClusterConnection clusterConnection;
    private final ClusterConnectionConfiguration configuration;

    public ClusterConnectionControlImpl(ClusterConnection clusterConnection, StorageManager storageManager, ClusterConnectionConfiguration configuration) throws Exception {
        super(ClusterConnectionControl.class, storageManager);
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
    }

    public String getAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getDiscoveryGroupName() {
        this.clearIO();
        try {
            String string = this.configuration.getDiscoveryGroupName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMaxHops() {
        this.clearIO();
        try {
            int n = this.configuration.getMaxHops();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getRetryInterval() {
        this.clearIO();
        try {
            long l = this.configuration.getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getNodeID() {
        this.clearIO();
        try {
            String string = this.clusterConnection.getNodeID();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getStaticConnectors() {
        this.clearIO();
        try {
            List<String> staticConnectors = this.configuration.getStaticConnectors();
            if (staticConnectors == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = staticConnectors.toArray(new String[staticConnectors.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getStaticConnectorsAsJSON() throws Exception {
        this.clearIO();
        try {
            String string = JsonUtil.toJsonArray(this.configuration.getStaticConnectors()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isDuplicateDetection() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isDuplicateDetection();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getMessageLoadBalancingType() {
        this.clearIO();
        try {
            String string = this.configuration.getMessageLoadBalancingType().getType();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTopology() {
        this.clearIO();
        try {
            String string = this.clusterConnection.getTopology().describe();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public Map<String, String> getNodes() throws Exception {
        this.clearIO();
        try {
            Map<String, String> map = this.clusterConnection.getNodes();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.clusterConnection.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void start() throws Exception {
        this.clearIO();
        try {
            this.clusterConnection.start();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void stop() throws Exception {
        this.clearIO();
        try {
            this.clusterConnection.stop();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(ClusterConnectionControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(ClusterConnectionControl.class);
    }
}

