/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.PolicyDefinitions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class PolicyParser {
    private final ElytronSubsystemParser elytronSubsystemParser;
    private volatile PersistentResourceXMLDescription description;

    PolicyParser(ElytronSubsystemParser elytronSubsystemParser) {
        this.elytronSubsystemParser = elytronSubsystemParser;
    }

    private void verifyNamespace(XMLExtendedStreamReader reader) throws XMLStreamException {
        this.elytronSubsystemParser.verifyNamespace(reader);
    }

    private PersistentResourceXMLDescription getXmlDescription() {
        String namespace;
        if (this.description == null && !(namespace = this.elytronSubsystemParser.getNamespace()).equals("urn:wildfly:elytron:1.0") && !namespace.equals("urn:wildfly:elytron:1.1")) {
            this.description = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"policy")).addAttribute((AttributeDefinition)PolicyDefinitions.JaccPolicyDefinition.POLICY).addAttribute((AttributeDefinition)PolicyDefinitions.CustomPolicyDefinition.POLICY).build();
        }
        return this.description;
    }

    void readPolicy(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PersistentResourceXMLDescription xmlDescription = this.getXmlDescription();
        if (xmlDescription == null) {
            this.readPolicyLegacy(parentAddress, reader, operations);
        } else {
            this.description.parse(reader, PathAddress.pathAddress((ModelNode)parentAddress), operations);
        }
    }

    private void readPolicyLegacy(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPolicy = new ModelNode();
        addPolicy.get("operation").set("add");
        String defaultPolicy = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "default-policy": {
                    ModelNode placeholder = new ModelNode().setEmptyObject();
                    PolicyDefinitions.RESOURCE_NAME.parseAndSetParameter(value, placeholder, (XMLStreamReader)reader);
                    defaultPolicy = value;
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (defaultPolicy == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"default-policy"});
        }
        boolean providerFound = false;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            this.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "jacc-policy": {
                    ModelNode providerModel = new ModelNode().setEmptyObject();
                    String policyName = this.parseJaccPolicy(providerModel, reader);
                    if (!providerFound && defaultPolicy.equals(policyName)) {
                        providerFound = true;
                        addPolicy.get("jacc-policy").set(providerModel);
                        continue block15;
                    }
                    ElytronSubsystemMessages.ROOT_LOGGER.discardingUnusedPolicy("jacc-policy", "name", policyName);
                    continue block15;
                }
                case "custom-policy": {
                    ModelNode providerModel = new ModelNode().setEmptyObject();
                    String policyName = this.parseCustomPolicy(providerModel, reader);
                    if (!providerFound && defaultPolicy.equals(policyName)) {
                        providerFound = true;
                        addPolicy.get("custom-policy").set(providerModel);
                        continue block15;
                    }
                    ElytronSubsystemMessages.ROOT_LOGGER.discardingUnusedPolicy("custom-policy", "name", policyName);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!providerFound) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.cannotFindPolicyProvider(defaultPolicy, reader.getLocation());
        }
        addPolicy.get("address").set(parentAddress).add("policy", defaultPolicy);
        operations.add(addPolicy);
    }

    private String parseJaccPolicy(ModelNode providerModel, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Collections.singletonList("name"));
        String name = null;
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "policy": {
                    PolicyDefinitions.JaccPolicyDefinition.POLICY_PROVIDER.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                case "configuration-factory": {
                    PolicyDefinitions.JaccPolicyDefinition.CONFIGURATION_FACTORY.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                case "module": {
                    PolicyDefinitions.JaccPolicyDefinition.MODULE.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return name;
    }

    private String parseCustomPolicy(ModelNode providerModel, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "class-name"));
        String name = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "class-name": {
                    PolicyDefinitions.CustomPolicyDefinition.CLASS_NAME.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block10;
                }
                case "module": {
                    PolicyDefinitions.CustomPolicyDefinition.MODULE.parseAndSetParameter(value, providerModel, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return name;
    }

    void writePolicy(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        PersistentResourceXMLDescription xmlDescription = this.getXmlDescription();
        if (xmlDescription == null) {
            throw new UnsupportedOperationException();
        }
        xmlDescription.persist(writer, subsystem);
    }
}

