/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.ProviderDefinitions;

class ProviderParser {
    private final PersistentResourceXMLDescription providerLoaderParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"provider-loader")).setUseElementsForGroups(false).addAttributes(new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, ClassLoadingAttributeDefinitions.CLASS_NAMES, ProviderDefinitions.PATH, ProviderDefinitions.RELATIVE_TO, ProviderDefinitions.ARGUMENT, ProviderDefinitions.CONFIGURATION}).build();
    private final PersistentResourceXMLDescription aggregateProviders = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"aggregate-providers")).addAttribute((AttributeDefinition)ProviderDefinitions.REFERENCES, (AttributeParser)new CommonAttributes.AggregateAttributeParser("providers"), (AttributeMarshaller)new CommonAttributes.AggregateAttributeMarshaller("providers")).build();
    private final ElytronSubsystemParser elytronSubsystemParser;

    ProviderParser(ElytronSubsystemParser elytronSubsystemParser) {
        this.elytronSubsystemParser = elytronSubsystemParser;
    }

    private void verifyNamespace(XMLExtendedStreamReader reader) throws XMLStreamException {
        this.elytronSubsystemParser.verifyNamespace(reader);
    }

    void readProviders(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            this.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "aggregate-providers": {
                    this.aggregateProviders.parse(reader, parentAddress, operations);
                    continue block8;
                }
                case "provider-loader": {
                    this.providerLoaderParser.parse(reader, parentAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void writeProviders(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-providers") || subsystem.hasDefined("provider-loader")) {
            writer.writeStartElement("providers");
            this.aggregateProviders.persist(writer, subsystem);
            this.providerLoaderParser.persist(writer, subsystem);
            writer.writeEndElement();
        }
    }
}

