/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.ifelse.ConditionArgument;
import org.jboss.as.cli.handlers.ifelse.IfElseControlFlow;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class IfHandler
extends CommandHandlerWithHelp {
    private final ConditionArgument condition = new ConditionArgument(this);
    private final ArgumentWithValue of;

    public IfHandler() {
        super("if", true);
        this.condition.addCantAppearAfter(this.helpArg);
        this.of = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                return Collections.singletonList("of");
            }
        }), 1, "--of");
        this.of.addRequiredPreceding(this.condition);
        ArgumentWithValue line = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                char ch;
                String conditionStr;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                String lnStr = IfHandler.this.of.getValue(args);
                if (lnStr == null) {
                    return -1;
                }
                String originalLine = args.getOriginalLine();
                try {
                    conditionStr = IfHandler.this.condition.getValue(args, true);
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                int i = originalLine.indexOf(conditionStr);
                if (i < 0) {
                    return -1;
                }
                if ((i = originalLine.indexOf("of ", i + conditionStr.length())) < 0) {
                    return -1;
                }
                String cmd = originalLine.substring(i + 3);
                int cmdResult = ctx.getDefaultCommandCompleter().complete(ctx, cmd, cmd.length(), candidates);
                if (cmdResult < 0) {
                    return cmdResult;
                }
                int escapeCorrection = 0;
                int start = originalLine.length() - 1 - buffer.length();
                while (start - escapeCorrection >= 0 && !Character.isWhitespace(ch = originalLine.charAt(start - escapeCorrection)) && ch != '=') {
                    ++escapeCorrection;
                }
                return buffer.length() + escapeCorrection - (cmd.length() - cmdResult);
            }
        }, Integer.MAX_VALUE, "--line"){};
        line.addRequiredPreceding(this.of);
    }

    public ConditionArgument getConditionArgument() {
        return this.condition;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return IfElseControlFlow.get(ctx) == null && !ctx.getBatchManager().isBatchActive();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        String argsStr = ctx.getArgumentsString();
        if (argsStr == null) {
            throw new CommandFormatException("The command is missing arguments.");
        }
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            throw new CommandFormatException("if is not allowed while in batch mode.");
        }
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String conditionStr = this.condition.getOriginalValue(args, true);
        int i = argsStr.indexOf(conditionStr);
        if (i < 0) {
            throw new CommandFormatException("Failed to locate '" + conditionStr + "' in '" + argsStr + "'");
        }
        if ((i = argsStr.indexOf("of", i + conditionStr.length())) < 0) {
            throw new CommandFormatException("Failed to locate 'of' in '" + argsStr + "'");
        }
        String requestStr = argsStr.substring(i + 2);
        ctx.registerRedirection(new IfElseControlFlow(ctx, this.condition.resolveOperation(args), requestStr));
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        return true;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return true;
    }
}

