/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.Configuration;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class ConfigurationBuilder
implements CapabilityServiceBuilder<Configuration>,
Service<Configuration> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private final Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> consumer;
    private volatile ValueDependency<CacheContainer> container;

    public ConfigurationBuilder(ServiceName name, String containerName, String cacheName, Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> consumer) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
        this.consumer = consumer;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<Configuration> configure(CapabilityServiceSupport support) {
        this.container = new InjectedValueDependency(InfinispanRequirement.CONTAINER.getServiceName(support, this.containerName), CacheContainer.class);
        return this;
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return this.container.register(target.addService(this.name, (Service)this).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }

    public Configuration getValue() {
        return ((CacheContainer)this.container.getValue()).getCacheConfiguration(this.cacheName);
    }

    public void start(StartContext context) throws StartException {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        this.consumer.accept(builder);
        ((CacheContainer)this.container.getValue()).defineConfiguration(this.cacheName, builder.build());
    }

    public void stop(StopContext context) {
        ((CacheContainer)this.container.getValue()).undefineConfiguration(this.cacheName);
    }
}

