/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.definition.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.NormalizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SimpleElasticsearchAnalysisDefinitionRegistry
implements ElasticsearchAnalysisDefinitionRegistry {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final Map<String, AnalyzerDefinition> analyzerDefinitions = new TreeMap<String, AnalyzerDefinition>();
    protected final Map<String, NormalizerDefinition> normalizerDefinitions = new TreeMap<String, NormalizerDefinition>();
    private final Map<String, TokenizerDefinition> tokenizerDefinitions = new TreeMap<String, TokenizerDefinition>();
    private final Map<String, TokenFilterDefinition> tokenFilterDefinitions = new TreeMap<String, TokenFilterDefinition>();
    private final Map<String, CharFilterDefinition> charFilterDefinitions = new TreeMap<String, CharFilterDefinition>();

    @Override
    public void register(String name, AnalyzerDefinition definition) {
        AnalyzerDefinition previous = this.analyzerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.analyzerNamingConflict(name);
        }
    }

    @Override
    public void register(String name, NormalizerDefinition definition) {
        NormalizerDefinition previous = this.normalizerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.normalizerNamingConflict(name);
        }
    }

    @Override
    public void register(String name, TokenizerDefinition definition) {
        TokenizerDefinition previous = this.tokenizerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.tokenizerNamingConflict(name);
        }
    }

    @Override
    public void register(String name, TokenFilterDefinition definition) {
        TokenFilterDefinition previous = this.tokenFilterDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.tokenFilterNamingConflict(name);
        }
    }

    @Override
    public void register(String name, CharFilterDefinition definition) {
        CharFilterDefinition previous = this.charFilterDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.charFilterNamingConflict(name);
        }
    }

    @Override
    public AnalyzerDefinition getAnalyzerDefinition(String name) {
        return this.analyzerDefinitions.get(name);
    }

    @Override
    public NormalizerDefinition getNormalizerDefinition(String name) {
        return this.normalizerDefinitions.get(name);
    }

    @Override
    public TokenizerDefinition getTokenizerDefinition(String name) {
        return this.tokenizerDefinitions.get(name);
    }

    @Override
    public TokenFilterDefinition getTokenFilterDefinition(String name) {
        return this.tokenFilterDefinitions.get(name);
    }

    @Override
    public CharFilterDefinition getCharFilterDefinition(String name) {
        return this.charFilterDefinitions.get(name);
    }

    public Map<String, AnalyzerDefinition> getAnalyzerDefinitions() {
        return Collections.unmodifiableMap(this.analyzerDefinitions);
    }

    public Map<String, NormalizerDefinition> getNormalizerDefinitions() {
        return Collections.unmodifiableMap(this.normalizerDefinitions);
    }

    public Map<String, TokenizerDefinition> getTokenizerDefinitions() {
        return Collections.unmodifiableMap(this.tokenizerDefinitions);
    }

    public Map<String, TokenFilterDefinition> getTokenFilterDefinitions() {
        return Collections.unmodifiableMap(this.tokenFilterDefinitions);
    }

    public Map<String, CharFilterDefinition> getCharFilterDefinitions() {
        return Collections.unmodifiableMap(this.charFilterDefinitions);
    }
}

