/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchInstantBridge
extends ElasticsearchTemporalAccessorStringBridge<Instant> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalDateBridge.FORMATTER).appendLiteral('T').optionalStart().append(ElasticsearchLocalTimeBridge.FORMATTER).optionalStart().appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter INDEX_NULL_AS_FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalDateBridge.FORMATTER).appendLiteral('T').optionalStart().append(ElasticsearchLocalTimeBridge.FORMATTER).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchInstantBridge INSTANCE = new ElasticsearchInstantBridge();

    private ElasticsearchInstantBridge() {
        super(FORMATTER, Instant.class, INDEX_NULL_AS_FORMATTER);
    }

    @Override
    String format(DateTimeFormatter formatter, Instant object) {
        return formatter.format(object == null ? null : object.atOffset(ZoneOffset.UTC));
    }

    @Override
    Instant parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return Instant.from(formatter.parse(stringValue));
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForInstant(e);
    }
}

