/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.search.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.elasticsearch.gson.impl.ObjectPropertyJsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.exception.AssertionFailure;

class RootJsonAccessor
implements JsonObjectAccessor,
JsonCompositeAccessor<JsonObject> {
    static final JsonObjectAccessor INSTANCE = new RootJsonAccessor();

    private RootJsonAccessor() {
    }

    @Override
    public Optional<JsonObject> get(JsonObject root) {
        return Optional.ofNullable(root);
    }

    @Override
    public void set(JsonObject root, JsonObject value) {
        throw new UnsupportedOperationException("Cannot set the root element");
    }

    @Override
    public void add(JsonObject root, JsonObject value) {
        throw new UnsupportedOperationException("Cannot add a value to the root element");
    }

    @Override
    public JsonObject getOrCreate(JsonObject root, Supplier<? extends JsonObject> newValueSupplier) throws UnexpectedJsonElementTypeException {
        return this.requireRoot(root);
    }

    @Override
    public JsonObject getOrCreate(JsonObject root) throws UnexpectedJsonElementTypeException {
        return this.requireRoot(root);
    }

    public String toString() {
        return "root";
    }

    @Override
    public String getStaticAbsolutePath() {
        return null;
    }

    @Override
    public UnknownTypeJsonAccessor property(String propertyName) {
        return new ObjectPropertyJsonAccessor(this, propertyName);
    }

    private JsonObject requireRoot(JsonObject root) {
        if (root == null) {
            throw new AssertionFailure("A null root was encountered");
        }
        return root;
    }
}

