/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.query.impl.ElasticsearchQueryFactory;
import org.hibernate.search.elasticsearch.query.impl.FailingOneWayFieldBridgeProjection;
import org.hibernate.search.elasticsearch.query.impl.FieldProjection;
import org.hibernate.search.elasticsearch.query.impl.JsonDrivenProjection;
import org.hibernate.search.elasticsearch.query.impl.PrimitiveProjection;
import org.hibernate.search.elasticsearch.query.impl.TwoWayFieldBridgeProjection;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.engine.impl.EntityInfoImpl;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class QueryHitConverter {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String SPATIAL_DISTANCE_FIELD = "_distance";
    private final Map<String, EntityIndexBinding> targetedEntityBindingsByName;
    private final Map<EntityIndexBinding, FieldProjection> idProjectionByEntityBinding;
    private final Map<EntityIndexBinding, FieldProjection[]> fieldProjectionsByEntityBinding;
    private final JsonElement sourceFilter;
    private final JsonElement scriptFields;
    private final boolean trackScore;
    private final String[] projectedFields;
    private final Integer sortByDistanceIndex;

    public static Builder builder(ElasticsearchQueryFactory queryFactory, Map<String, EntityIndexBinding> targetedEntityBindingsByName) {
        return new Builder(queryFactory, targetedEntityBindingsByName);
    }

    private QueryHitConverter(Map<String, EntityIndexBinding> targetedEntityBindingsByName, Map<EntityIndexBinding, FieldProjection> idProjectionByEntityBinding, Map<EntityIndexBinding, FieldProjection[]> fieldProjectionsByEntityBinding, JsonElement sourceFilter, JsonElement scriptFields, boolean trackScore, String[] projectedFields, Integer sortByDistanceIndex) {
        this.targetedEntityBindingsByName = targetedEntityBindingsByName;
        this.idProjectionByEntityBinding = idProjectionByEntityBinding;
        this.fieldProjectionsByEntityBinding = fieldProjectionsByEntityBinding;
        this.sourceFilter = sourceFilter;
        this.trackScore = trackScore;
        this.projectedFields = projectedFields;
        this.scriptFields = scriptFields;
        this.sortByDistanceIndex = sortByDistanceIndex;
    }

    public void contributeToPayload(JsonBuilder.Object payloadBuilder) {
        if (this.trackScore) {
            payloadBuilder.addProperty("track_scores", true);
        }
        payloadBuilder.add("_source", this.sourceFilter);
        if (this.scriptFields != null) {
            payloadBuilder.add("script_fields", this.scriptFields);
        }
    }

    public EntityInfo convert(SearchResult searchResult, JsonObject hit) {
        String type = hit.get("_type").getAsString();
        EntityIndexBinding binding = this.targetedEntityBindingsByName.get(type);
        if (binding == null) {
            LOG.warnf("Found unknown type in Elasticsearch index: " + type, new Object[0]);
            return null;
        }
        DocumentBuilderIndexedEntity documentBuilder = binding.getDocumentBuilder();
        IndexedTypeIdentifier typeId = documentBuilder.getTypeIdentifier();
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        conversionContext.setConvertedTypeId(typeId);
        FieldProjection idProjection = this.idProjectionByEntityBinding.get(binding);
        Object id = idProjection.convertHit(hit, (ConversionContext)conversionContext);
        Object[] projections = null;
        if (this.projectedFields != null) {
            projections = new Object[this.projectedFields.length];
            block20: for (int i = 0; i < projections.length; ++i) {
                String field = this.projectedFields[i];
                if (field == null) continue;
                switch (field) {
                    case "__HSearch_Source": {
                        projections[i] = hit.getAsJsonObject().get("_source").toString();
                        continue block20;
                    }
                    case "__HSearch_id": {
                        projections[i] = id;
                        continue block20;
                    }
                    case "_hibernate_class": {
                        projections[i] = typeId.getPojoType();
                        continue block20;
                    }
                    case "__HSearch_Score": {
                        projections[i] = Float.valueOf(hit.getAsJsonObject().get("_score").getAsFloat());
                        continue block20;
                    }
                    case "_HSearch_SpatialDistance": {
                        JsonElement distance = null;
                        if (this.sortByDistanceIndex != null) {
                            distance = hit.getAsJsonObject().get("sort").getAsJsonArray().get(this.sortByDistanceIndex.intValue());
                        } else {
                            JsonElement fields = hit.getAsJsonObject().get("fields");
                            if (fields != null) {
                                distance = hit.getAsJsonObject().get("fields").getAsJsonObject().get(SPATIAL_DISTANCE_FIELD);
                            }
                        }
                        if (distance != null && distance.isJsonArray()) {
                            JsonArray array = distance.getAsJsonArray();
                            JsonElement jsonElement = distance = array.size() >= 1 ? array.get(0) : null;
                        }
                        if (distance == null || distance.isJsonNull()) {
                            projections[i] = null;
                            continue block20;
                        }
                        Double distanceAsDouble = distance.getAsDouble();
                        if (distanceAsDouble == Double.MAX_VALUE || distanceAsDouble.isInfinite()) {
                            projections[i] = null;
                            continue block20;
                        }
                        projections[i] = distance.getAsDouble();
                        continue block20;
                    }
                    case "__HSearch_Took": {
                        projections[i] = searchResult.getTook();
                        continue block20;
                    }
                    case "__HSearch_TimedOut": {
                        projections[i] = searchResult.getTimedOut();
                        continue block20;
                    }
                    case "__HSearch_This": {
                        projections[i] = EntityInfo.ENTITY_PLACEHOLDER;
                        continue block20;
                    }
                    default: {
                        FieldProjection projection = this.fieldProjectionsByEntityBinding.get(binding)[i];
                        projections[i] = projection.convertHit(hit, (ConversionContext)conversionContext);
                    }
                }
            }
        }
        return new EntityInfoImpl(typeId, documentBuilder.getIdPropertyName(), (Serializable)id, projections);
    }

    public static class Builder {
        private final ElasticsearchQueryFactory queryFactory;
        private final Map<String, EntityIndexBinding> targetedEntityBindingsByName;
        private final Map<EntityIndexBinding, FieldProjection> idProjectionByEntityBinding = new HashMap<EntityIndexBinding, FieldProjection>();
        private final Map<EntityIndexBinding, FieldProjection[]> fieldProjectionsByEntityBinding = new HashMap<EntityIndexBinding, FieldProjection[]>();
        private boolean trackScore = false;
        private boolean includeAllSource = false;
        private boolean hasSpatialDistanceProjection = false;
        private Integer sortByDistanceIndex = null;
        private Coordinates spatialSearchCenter;
        private String spatialFieldName;
        private final JsonBuilder.Array sourceFilterCollector = JsonBuilder.array();
        private String[] projectedFields;

        private Builder(ElasticsearchQueryFactory queryFactory, Map<String, EntityIndexBinding> targetedEntityBindingsByName) {
            this.queryFactory = queryFactory;
            this.targetedEntityBindingsByName = targetedEntityBindingsByName;
            for (EntityIndexBinding binding : targetedEntityBindingsByName.values()) {
                DocumentBuilderIndexedEntity documentBuilder = binding.getDocumentBuilder();
                String idFieldName = documentBuilder.getIdFieldName();
                TypeMetadata typeMetadata = documentBuilder.getTypeMetadata();
                FieldProjection projection = this.createProjection(typeMetadata, idFieldName);
                this.idProjectionByEntityBinding.put(binding, projection);
            }
        }

        public Builder setSortByDistance(Integer sortIndex, Coordinates spatialSearchCenter, String spatialFieldName) {
            this.sortByDistanceIndex = sortIndex;
            this.spatialSearchCenter = spatialSearchCenter;
            this.spatialFieldName = spatialFieldName;
            return this;
        }

        public Builder setProjectedFields(String[] projectedFields) {
            if (this.projectedFields != null) {
                throw new AssertionFailure("Projected fields set twice for a single query hit extractor");
            }
            this.projectedFields = projectedFields;
            if (projectedFields == null) {
                return this;
            }
            block16: for (int i = 0; i < projectedFields.length; ++i) {
                String projectedField = projectedFields[i];
                if (projectedField == null) continue;
                switch (projectedField) {
                    case "__HSearch_Source": {
                        this.includeAllSource = true;
                        continue block16;
                    }
                    case "__HSearch_Score": {
                        this.trackScore = true;
                        continue block16;
                    }
                    case "__HSearch_id": 
                    case "__HSearch_This": 
                    case "_hibernate_class": 
                    case "__HSearch_Took": 
                    case "__HSearch_TimedOut": {
                        continue block16;
                    }
                    case "_HSearch_SpatialDistance": {
                        this.hasSpatialDistanceProjection = true;
                        continue block16;
                    }
                    default: {
                        for (EntityIndexBinding binding : this.targetedEntityBindingsByName.values()) {
                            TypeMetadata typeMetadata = binding.getDocumentBuilder().getTypeMetadata();
                            FieldProjection projection = this.createProjection(typeMetadata, projectedField);
                            FieldProjection[] projectionsForType = this.fieldProjectionsByEntityBinding.get(binding);
                            if (projectionsForType == null) {
                                projectionsForType = new FieldProjection[projectedFields.length];
                                this.fieldProjectionsByEntityBinding.put(binding, projectionsForType);
                            }
                            projectionsForType[i] = projection;
                        }
                    }
                }
            }
            return this;
        }

        public QueryHitConverter build() {
            JsonArray array;
            Object sourceFilter = this.includeAllSource ? new JsonPrimitive("*") : ((array = this.sourceFilterCollector.build()).size() > 0 ? array : new JsonPrimitive(Boolean.valueOf(false)));
            JsonObject scriptFields = null;
            if (this.hasSpatialDistanceProjection && this.sortByDistanceIndex == null) {
                scriptFields = JsonBuilder.object().add(QueryHitConverter.SPATIAL_DISTANCE_FIELD, JsonBuilder.object().add("script", (JsonElement)this.queryFactory.createSpatialDistanceScript(this.spatialSearchCenter, this.spatialFieldName))).build();
            }
            return new QueryHitConverter(this.targetedEntityBindingsByName, this.idProjectionByEntityBinding, this.fieldProjectionsByEntityBinding, (JsonElement)sourceFilter, (JsonElement)scriptFields, this.trackScore, this.projectedFields, this.sortByDistanceIndex);
        }

        private FieldProjection createProjection(TypeMetadata rootTypeMetadata, String projectedField) {
            DocumentFieldMetadata fieldMetadata = rootTypeMetadata.getDocumentFieldMetadataFor(projectedField);
            if (fieldMetadata != null) {
                return this.createProjection(rootTypeMetadata, fieldMetadata);
            }
            BridgeDefinedField bridgeDefinedField = rootTypeMetadata.getBridgeDefinedFieldMetadataFor(projectedField);
            if (bridgeDefinedField != null) {
                String absoluteName = bridgeDefinedField.getAbsoluteName();
                FieldHelper.ExtendedFieldType type = FieldHelper.getType(bridgeDefinedField);
                this.sourceFilterCollector.add((JsonElement)new JsonPrimitive(absoluteName));
                return new PrimitiveProjection(rootTypeMetadata, absoluteName, type);
            }
            this.sourceFilterCollector.add((JsonElement)new JsonPrimitive(projectedField));
            return new JsonDrivenProjection(projectedField);
        }

        private FieldProjection createProjection(TypeMetadata rootTypeMetadata, DocumentFieldMetadata fieldMetadata) {
            String absoluteName = fieldMetadata.getAbsoluteName();
            FieldBridge fieldBridge = fieldMetadata.getFieldBridge();
            FieldHelper.ExtendedFieldType type = FieldHelper.getType((PartialDocumentFieldMetadata)fieldMetadata);
            if (FieldHelper.ExtendedFieldType.BOOLEAN.equals((Object)type)) {
                this.sourceFilterCollector.add((JsonElement)new JsonPrimitive(absoluteName));
                return new PrimitiveProjection(rootTypeMetadata, absoluteName, type);
            }
            if (fieldBridge instanceof TwoWayFieldBridge) {
                Collection bridgeDefinedFields = fieldMetadata.getBridgeDefinedFields().values();
                HashSet<String> objectFieldNames = new HashSet<String>();
                HashMap<String, PrimitiveProjection> primitiveProjections = new HashMap<String, PrimitiveProjection>();
                for (BridgeDefinedField bridgeDefinedField : bridgeDefinedFields) {
                    String nestedAbsoluteName = bridgeDefinedField.getAbsoluteName();
                    FieldHelper.ExtendedFieldType nestedType = FieldHelper.getType(bridgeDefinedField);
                    if (FieldHelper.ExtendedFieldType.OBJECT.equals((Object)nestedType)) {
                        objectFieldNames.add(nestedAbsoluteName);
                    } else {
                        PrimitiveProjection projection = new PrimitiveProjection(rootTypeMetadata, nestedAbsoluteName, type);
                        primitiveProjections.put(nestedAbsoluteName, projection);
                    }
                    this.sourceFilterCollector.add((JsonElement)new JsonPrimitive(nestedAbsoluteName));
                }
                if (!objectFieldNames.contains(absoluteName) && !primitiveProjections.containsKey(absoluteName)) {
                    PrimitiveProjection defaultFieldProjection = new PrimitiveProjection(rootTypeMetadata, absoluteName, type);
                    primitiveProjections.put(absoluteName, defaultFieldProjection);
                    this.sourceFilterCollector.add((JsonElement)new JsonPrimitive(absoluteName));
                }
                return new TwoWayFieldBridgeProjection(absoluteName, (TwoWayFieldBridge)fieldBridge, objectFieldNames, primitiveProjections);
            }
            return new FailingOneWayFieldBridgeProjection(absoluteName, fieldBridge.getClass());
        }
    }
}

