/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParameterValueTransformer;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class MapParameterValueTransformer
implements ParameterValueTransformer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Class<?> factoryClass;
    private final String parameterName;
    private final Map<String, JsonElement> translations;

    public MapParameterValueTransformer(Class<?> factoryClass, String parameterName, Map<String, JsonElement> translations) {
        this.factoryClass = factoryClass;
        this.parameterName = parameterName;
        this.translations = translations;
    }

    @Override
    public JsonElement transform(String parameterValue) {
        JsonElement translatedValue = this.translations.get(parameterValue);
        if (translatedValue == null) {
            throw log.unsupportedAnalysisDefinitionParameterValue(this.factoryClass, this.parameterName, parameterValue);
        }
        return translatedValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.factoryClass + "," + this.parameterName + "," + this.translations + "]";
    }
}

