/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;

public class ES2IndexTypeJsonAdapter
extends TypeAdapter<IndexType> {
    private static final String ANALYZED_STRING = "analyzed";
    private static final String NOT_ANALYZED_STRING = "not_analyzed";
    private static final String NO_STRING = "no";

    public void write(JsonWriter out, IndexType value) throws IOException {
        switch (value) {
            case ANALYZED: {
                out.value(ANALYZED_STRING);
                break;
            }
            case NOT_ANALYZED: {
                out.value(NOT_ANALYZED_STRING);
                break;
            }
            case NO: {
                out.value(NO_STRING);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid value for IndexType in ES2: " + (Object)((Object)value));
            }
        }
    }

    public IndexType read(JsonReader in) throws IOException {
        String value;
        switch (value = in.nextString()) {
            case "analyzed": {
                return IndexType.ANALYZED;
            }
            case "not_analyzed": {
                return IndexType.NOT_ANALYZED;
            }
            case "no": {
                return IndexType.NO;
            }
        }
        throw new IllegalStateException("Invalid value for IndexType in ES2: " + value);
    }
}

