/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.collections.Iterators;

public final class Iterables {
    private Iterables() {
    }

    public static <T> boolean addAll(Collection<T> target, Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return target.addAll((Collection)iterable);
        }
        return Iterators.addAll(target, iterable.iterator());
    }

    public static <T> String toMultiRowString(Iterable<T> iterable) {
        StringBuilder builder = new StringBuilder("\n  - ");
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            builder.append(element);
            if (!iterator.hasNext()) continue;
            builder.append(",\n  - ");
        }
        return builder.toString();
    }

    public static <F, T> Iterable<T> flatMap(Iterable<F> iterable, Function<F, Iterable<T>> function) {
        return Iterables.concat(Iterables.transform(iterable, function));
    }

    public static <T> Iterable<T> concat(final Iterable<? extends Iterable<? extends T>> iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.concat(Iterables.iterators(iterables));
            }
        };
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return Iterables.concat(Arrays.asList(a, b));
    }

    public static <T> Iterator<Iterator<? extends T>> iterators(Iterable<? extends Iterable<? extends T>> iterables) {
        return Iterators.transform(iterables.iterator(), new Function<Iterable<? extends T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Iterable<? extends T> ts) {
                return ts.iterator();
            }
        });
    }

    public static <T, R> Iterable<R> transform(final Iterable<T> iterable, final Function<? super T, ? extends R> function) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new Iterators.TransformingIterator(iterable.iterator(), function);
            }
        };
    }
}

