/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.util.Supplier;
import org.jboss.weld.util.collections.AbstractMultimap;
import org.jboss.weld.util.collections.Multimap;

public class SetMultimap<K, V>
extends AbstractMultimap<K, V, Set<V>> {
    private static final long serialVersionUID = -7310409235342796148L;

    public static <K, V> SetMultimap<K, V> newSetMultimap() {
        return new SetMultimap<K, V>(new Supplier<Map<K, Set<V>>>(){

            @Override
            public HashMap<K, Set<V>> get() {
                return new HashMap();
            }
        }, null, new Supplier<Set<V>>(){

            @Override
            public HashSet<V> get() {
                return new HashSet();
            }
        }, null);
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap(Multimap<K, V> multimap) {
        return new SetMultimap<K, V>(new Supplier<Map<K, Set<V>>>(){

            @Override
            public HashMap<K, Set<V>> get() {
                return new HashMap();
            }
        }, null, new Supplier<Set<V>>(){

            @Override
            public HashSet<V> get() {
                return new HashSet();
            }
        }, multimap);
    }

    public static <K, V> SetMultimap<K, V> newConcurrentSetMultimap() {
        return SetMultimap.newConcurrentSetMultimap(new Supplier<Set<V>>(){

            @Override
            public Set<V> get() {
                return Collections.synchronizedSet(new HashSet());
            }
        });
    }

    public static <K, V> SetMultimap<K, V> newConcurrentSetMultimap(Supplier<Set<V>> valueSupplier) {
        return new SetMultimap<K, V>(null, new Supplier<ConcurrentMap<K, Set<V>>>(){

            @Override
            public ConcurrentMap<K, Set<V>> get() {
                return new ConcurrentHashMap();
            }
        }, valueSupplier, null);
    }

    private SetMultimap(Supplier<Map<K, Set<V>>> mapSupplier, Supplier<ConcurrentMap<K, Set<V>>> concurrentMapSupplier, Supplier<Set<V>> collectionSupplier, Multimap<K, V> multimap) {
        super(mapSupplier, concurrentMapSupplier, collectionSupplier, multimap);
    }
}

