/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.container.AeshCommandContainerBuilder;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.util.LoggerUtil;

public class MutableCommandRegistry
implements CommandRegistry {
    private final Map<String, CommandContainer<Command>> registry = new HashMap<String, CommandContainer<Command>>();
    private final Map<String, CommandContainer<Command>> aliases = new HashMap<String, CommandContainer<Command>>();
    private CommandContainerBuilder containerBuilder;
    private static final Logger LOGGER = LoggerUtil.getLogger(MutableCommandRegistry.class.getName());

    public void setCommandContainerBuilder(CommandContainerBuilder containerBuilder) {
        this.containerBuilder = containerBuilder;
    }

    @Override
    public CommandContainer getCommand(String name, String line) throws CommandNotFoundException {
        if (this.registry.containsKey(name)) {
            return this.registry.get(name);
        }
        if (name.contains(" ")) {
            String[] names = name.split(" ");
            if (this.registry.containsKey(names[0])) {
                return this.registry.get(names[0]);
            }
            throw new CommandNotFoundException("Command: " + names[0] + " was not found.");
        }
        throw new CommandNotFoundException("Command: " + name + " was not found.");
    }

    @Override
    public List<CommandLineParser<?>> getChildCommandParsers(String parent) throws CommandNotFoundException {
        CommandContainer c = this.getCommand(parent, "");
        if (c == null) {
            throw new CommandNotFoundException("Command: " + parent + " was not found.");
        }
        return Collections.unmodifiableList(c.getParser().getAllChildParsers());
    }

    @Override
    public void completeCommandName(CompleteOperation co) {
        ArrayList<String> names = new ArrayList<String>();
        for (CommandContainer<Command> command : this.registry.values()) {
            ProcessedCommand<Command> com = command.getParser().getProcessedCommand();
            if (com.getName().startsWith(co.getBuffer()) && com.getActivator().isActivated(com)) {
                if (command.getParser().isGroupCommand()) {
                    LOGGER.info("command is a group command");
                    if (!com.hasOptions() && !com.hasArgument()) {
                        LOGGER.info("adding add: " + command.getParser().getAllNames());
                        names.addAll(command.getParser().getAllNames());
                        co.setIgnoreNonEscapedSpace(true);
                        continue;
                    }
                    names.add(com.getName());
                    continue;
                }
                names.add(com.getName());
                continue;
            }
            if (!command.getParser().isGroupCommand() || !co.getBuffer().startsWith(com.getName()) || !com.getActivator().isActivated(com)) continue;
            String groupLine = Parser.trimInFront(co.getBuffer().substring(com.getName().length()));
            int diff = co.getBuffer().length() - groupLine.length();
            for (CommandLineParser<Command> child : command.getParser().getAllChildParsers()) {
                if (!child.getProcessedCommand().getName().startsWith(groupLine) || !child.getProcessedCommand().getActivator().isActivated(child.getProcessedCommand())) continue;
                names.add(co.getBuffer().substring(0, diff) + child.getProcessedCommand().getName());
            }
        }
        co.addCompletionCandidates(names);
    }

    @Override
    public Set<String> getAllCommandNames() {
        return this.registry.keySet();
    }

    public void addCommand(CommandContainer container) {
        this.putIntoRegistry(container);
    }

    public void addCommand(Command command) {
        this.putIntoRegistry(this.getBuilder().create(command));
    }

    public void addCommand(Class<? extends Command> command) {
        this.putIntoRegistry(this.getBuilder().create(command));
    }

    public void addAllCommands(List<Command> commands) {
        if (commands != null) {
            for (Command command : commands) {
                this.addCommand(command);
            }
        }
    }

    public void addAllCommandContainers(List<CommandContainer> commands) {
        if (commands != null) {
            for (CommandContainer command : commands) {
                this.addCommand(command);
            }
        }
    }

    private void putIntoRegistry(CommandContainer commandContainer) {
        if (!commandContainer.haveBuildError() && !this.contains(commandContainer.getParser().getProcessedCommand())) {
            this.registry.put(commandContainer.getParser().getProcessedCommand().getName(), commandContainer);
            ProcessedCommand command = commandContainer.getParser().getProcessedCommand();
            for (String alias : command.getAliases()) {
                this.aliases.put(alias, commandContainer);
            }
        }
    }

    private boolean contains(ProcessedCommand<?> command) {
        if (this.registry.containsKey(command.getName())) {
            return true;
        }
        for (String alias : command.getAliases()) {
            if (!this.aliases.containsKey(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeCommand(String name) {
        if (this.registry.containsKey(name)) {
            CommandContainer<Command> container = this.registry.remove(name);
            ProcessedCommand<Command> command = container.getParser().getProcessedCommand();
            for (String alias : command.getAliases()) {
                this.aliases.remove(alias);
            }
        }
    }

    private CommandContainerBuilder getBuilder() {
        if (this.containerBuilder == null) {
            this.containerBuilder = new AeshCommandContainerBuilder();
        }
        return this.containerBuilder;
    }

    @Override
    public CommandContainer getCommandByAlias(String alias) throws CommandNotFoundException {
        if (this.aliases.containsKey(alias)) {
            return this.aliases.get(alias);
        }
        throw new CommandNotFoundException("Command: with " + alias + " alias was not found.");
    }
}

