/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanResponse;

public class InfinispanCacheResponse
extends InfinispanResponse {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final String TIME_TO_LIVE_HEADER = "timeToLiveSeconds";
    private static final String MAX_IDLE_TIME_HEADER = "maxIdleTimeSeconds";
    private static final String CLUSTER_PRIMARY_OWNER_HEADER = "Cluster-Primary-Owner";
    private static final String CLUSTER_NODE_NAME_HEADER = "Cluster-Node-Name";
    private static final String CLUSTER_SERVER_ADDRESS_HEADER = "Cluster-Server-Address";
    private Optional<String> etag = Optional.empty();
    private Optional<CacheControl> cacheControl = Optional.empty();
    private Optional<Date> lastModified = Optional.empty();
    private Optional<Date> expires = Optional.empty();
    private Optional<Long> timeToLive = Optional.empty();
    private Optional<Long> maxIdle = Optional.empty();
    private Optional<String> clusterPrimaryOwner = Optional.empty();
    private Optional<String> clusterNodeName = Optional.empty();
    private Optional<String> clusterServerAddress = Optional.empty();

    private InfinispanCacheResponse(Optional<InfinispanRequest> request) {
        super(request);
    }

    @Override
    protected void addSpecificHeaders(FullHttpResponse response) {
        this.etag.ifPresent(e -> response.headers().set((CharSequence)HttpHeaderNames.ETAG, e));
        this.cacheControl.ifPresent(e -> response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, e));
        this.lastModified.ifPresent(e -> response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)DATE_TIME_FORMATTER.format(e.toInstant())));
        this.expires.ifPresent(e -> response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)DATE_TIME_FORMATTER.format(e.toInstant())));
        this.timeToLive.ifPresent(e -> response.headers().set(TIME_TO_LIVE_HEADER, (Object)TimeUnit.MILLISECONDS.toSeconds((long)e)));
        this.maxIdle.ifPresent(e -> response.headers().set(MAX_IDLE_TIME_HEADER, (Object)TimeUnit.MILLISECONDS.toSeconds((long)e)));
        this.clusterPrimaryOwner.ifPresent(e -> response.headers().set(CLUSTER_PRIMARY_OWNER_HEADER, e));
        this.clusterNodeName.ifPresent(e -> response.headers().set(CLUSTER_NODE_NAME_HEADER, e));
        this.clusterServerAddress.ifPresent(e -> response.headers().set(CLUSTER_SERVER_ADDRESS_HEADER, e));
    }

    public static InfinispanCacheResponse inReplyTo(InfinispanRequest request) {
        return new InfinispanCacheResponse(Optional.of(request));
    }

    public void etag(String etag) {
        this.etag = Optional.of(etag);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.cacheControl = Optional.ofNullable(cacheControl);
    }

    public void lastModified(Date lastModified) {
        this.lastModified = Optional.ofNullable(lastModified);
    }

    public void expires(Date expires) {
        this.expires = Optional.ofNullable(expires);
    }

    public void timeToLive(long lifespan) {
        if (lifespan > -1L) {
            this.timeToLive = Optional.of(lifespan);
        }
    }

    public void maxIdle(long maxIdle) {
        if (maxIdle > -1L) {
            this.maxIdle = Optional.of(maxIdle);
        }
    }

    public void clusterPrimaryOwner(String primaryOwner) {
        this.clusterPrimaryOwner = Optional.of(primaryOwner);
    }

    public void clusterNodeName(String nodeName) {
        this.clusterNodeName = Optional.of(nodeName);
    }

    public void clusterServerAddress(String serverAddress) {
        this.clusterServerAddress = Optional.of(serverAddress);
    }
}

