/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import java.util.Collections;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestChannelInitializer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.impl.VoidAuthenticator;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.operations.CacheOperations;
import org.infinispan.rest.operations.SearchOperations;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyInitializers;

public class RestServer
extends AbstractProtocolServer<RestServerConfiguration> {
    private Authenticator authenticator = new VoidAuthenticator();
    private CacheOperations cacheOperations;
    private SearchOperations searchOperations;

    public RestServer() {
        super("REST");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(Collections.singletonList(this.getRestChannelInitializer()));
    }

    public RestChannelInitializer getRestChannelInitializer() {
        return new RestChannelInitializer(this, this.transport);
    }

    Authenticator getAuthenticator() {
        return this.authenticator;
    }

    CacheOperations getCacheOperations() {
        return this.cacheOperations;
    }

    SearchOperations getSearchOperations() {
        return this.searchOperations;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void startInternal(RestServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
        RestCacheManager<Object> restCacheManager = new RestCacheManager<Object>(cacheManager, arg_0 -> ((RestServer)this).isCacheIgnored(arg_0));
        this.cacheOperations = new CacheOperations(configuration, restCacheManager);
        this.searchOperations = new SearchOperations(configuration, restCacheManager);
    }
}

