/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

public class ChannelNodeFactoryBuilder
implements CapabilityServiceBuilder<ChannelNodeFactory> {
    private final ServiceName name;
    private final String group;
    private volatile ValueDependency<Channel> channel;

    public ChannelNodeFactoryBuilder(ServiceName name, String group) {
        this.name = name;
        this.group = group;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<ChannelNodeFactory> configure(CapabilityServiceSupport support) {
        this.channel = new InjectedValueDependency(JGroupsRequirement.CHANNEL.getServiceName(support, this.group), Channel.class);
        return this;
    }

    public ServiceBuilder<ChannelNodeFactory> build(ServiceTarget target) {
        Supplier<ChannelNodeFactory> supplier = () -> new ChannelNodeFactory((Channel)this.channel.getValue());
        SuppliedValueService service = new SuppliedValueService(Function.identity(), supplier, Consumers.close());
        return this.channel.register(target.addService(this.name, (Service)service).setInitialMode(ServiceController.Mode.PASSIVE));
    }
}

