/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.Evictor;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEvictionCommand;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEvictionContext;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class BeanGroupEvictionScheduler<I>
implements Scheduler<I>,
BeanGroupEvictionContext<I> {
    private final Set<I> evictionQueue = new LinkedHashSet<I>();
    private final Batcher<TransactionBatch> batcher;
    private final Evictor<I> evictor;
    private final CommandDispatcher<BeanGroupEvictionContext<I>> dispatcher;
    private final PassivationConfiguration<?> config;

    public BeanGroupEvictionScheduler(String name, Batcher<TransactionBatch> batcher, Evictor<I> evictor, CommandDispatcherFactory dispatcherFactory, PassivationConfiguration<?> config) {
        this.batcher = batcher;
        this.evictor = evictor;
        this.config = config;
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)name, (Object)this);
    }

    @Override
    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    @Override
    public Evictor<I> getEvictor() {
        return this.evictor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(I id) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Locality locality) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            Iterator<I> groups = this.evictionQueue.iterator();
            while (groups.hasNext() && !Thread.currentThread().isInterrupted()) {
                I id = groups.next();
                if (locality.isLocal(id)) continue;
                groups.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(I id) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.add(id);
            if (this.evictionQueue.size() > this.config.getConfiguration().getMaxSize()) {
                Iterator<I> groups = this.evictionQueue.iterator();
                I group = groups.next();
                try {
                    this.dispatcher.submitOnCluster(new BeanGroupEvictionCommand<I>(group), new Node[0]);
                    groups.remove();
                }
                catch (Exception e) {
                    InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBean(e, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.clear();
        }
        this.dispatcher.close();
    }
}

