/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.messageinterpolation.el;

import java.lang.reflect.Method;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.hibernate.validator.internal.engine.messageinterpolation.el.MapBasedFunctionMapper;
import org.hibernate.validator.internal.engine.messageinterpolation.el.MapBasedVariableMapper;
import org.hibernate.validator.internal.engine.messageinterpolation.el.RootResolver;

public class SimpleELContext
extends ELContext {
    private static final ELResolver DEFAULT_RESOLVER = new CompositeELResolver(){
        {
            this.add(new RootResolver());
            this.add((ELResolver)new ArrayELResolver(false));
            this.add((ELResolver)new ListELResolver(false));
            this.add((ELResolver)new MapELResolver(false));
            this.add((ELResolver)new ResourceBundleELResolver());
            this.add((ELResolver)new BeanELResolver(false));
        }
    };
    private final MapBasedFunctionMapper functions;
    private final VariableMapper variableMapper;
    private final ELResolver resolver;

    public SimpleELContext(ExpressionFactory expressionFactory) {
        this.putContext(ExpressionFactory.class, expressionFactory);
        this.functions = new MapBasedFunctionMapper();
        this.variableMapper = new MapBasedVariableMapper();
        this.resolver = DEFAULT_RESOLVER;
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public MapBasedFunctionMapper getFunctionMapper() {
        return this.functions;
    }

    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    public ValueExpression setVariable(String name, ValueExpression expression) {
        return this.variableMapper.setVariable(name, expression);
    }

    public void setFunction(String prefix, String localName, Method method) {
        this.functions.setFunction(prefix, localName, method);
    }
}

