/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.Connectors;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.SameThreadExecutor;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RequestLimit {
    private volatile int requests;
    private volatile int max;
    private static final AtomicIntegerFieldUpdater<RequestLimit> requestsUpdater = AtomicIntegerFieldUpdater.newUpdater(RequestLimit.class, "requests");
    private volatile HttpHandler failureHandler = new ResponseCodeHandler(513);
    private final Queue<SuspendedRequest> queue;
    private final ExchangeCompletionListener COMPLETION_LISTENER = new ExchangeCompletionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                RequestLimit requestLimit = RequestLimit.this;
                synchronized (requestLimit) {
                    SuspendedRequest task = (SuspendedRequest)RequestLimit.this.queue.poll();
                    if (task != null) {
                        task.exchange.addExchangeCompleteListener(RequestLimit.this.COMPLETION_LISTENER);
                        task.exchange.dispatch(task.next);
                    } else {
                        RequestLimit.this.decrementRequests();
                    }
                }
            }
            finally {
                nextListener.proceed();
            }
        }
    };

    public RequestLimit(int maximumConcurrentRequests) {
        this(maximumConcurrentRequests, -1);
    }

    public RequestLimit(int maximumConcurrentRequests, int queueSize) {
        if (maximumConcurrentRequests < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        this.max = maximumConcurrentRequests;
        this.queue = new LinkedBlockingQueue<SuspendedRequest>(queueSize <= 0 ? Integer.MAX_VALUE : queueSize);
    }

    public void handleRequest(final HttpServerExchange exchange, final HttpHandler next) throws Exception {
        int newVal;
        int oldVal;
        do {
            if ((oldVal = this.requests) < this.max) continue;
            exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RequestLimit requestLimit = RequestLimit.this;
                    synchronized (requestLimit) {
                        int newVal;
                        int oldVal;
                        do {
                            if ((oldVal = RequestLimit.this.requests) >= RequestLimit.this.max) {
                                if (!RequestLimit.this.queue.offer(new SuspendedRequest(exchange, next))) {
                                    Connectors.executeRootHandler(RequestLimit.this.failureHandler, exchange);
                                }
                                return;
                            }
                            newVal = oldVal + 1;
                        } while (!requestsUpdater.compareAndSet(RequestLimit.this, oldVal, newVal));
                        exchange.addExchangeCompleteListener(RequestLimit.this.COMPLETION_LISTENER);
                        exchange.dispatch(next);
                    }
                }
            });
            return;
        } while (!requestsUpdater.compareAndSet(this, oldVal, newVal = oldVal + 1));
        exchange.addExchangeCompleteListener(this.COMPLETION_LISTENER);
        next.handleRequest(exchange);
    }

    public int getMaximumConcurrentRequests() {
        return this.max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaximumConcurrentRequests(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        int oldMax = this.max;
        this.max = newMax;
        if (newMax > oldMax) {
            RequestLimit requestLimit = this;
            synchronized (requestLimit) {
                while (!this.queue.isEmpty()) {
                    int newVal;
                    int oldVal;
                    do {
                        if ((oldVal = this.requests) < this.max) continue;
                        return oldMax;
                    } while (!requestsUpdater.compareAndSet(this, oldVal, newVal = oldVal + 1));
                    SuspendedRequest res = this.queue.poll();
                    res.exchange.dispatch(res.next);
                }
            }
        }
        return oldMax;
    }

    private void decrementRequests() {
        requestsUpdater.decrementAndGet(this);
    }

    public HttpHandler getFailureHandler() {
        return this.failureHandler;
    }

    public void setFailureHandler(HttpHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    private static final class SuspendedRequest {
        final HttpServerExchange exchange;
        final HttpHandler next;

        private SuspendedRequest(HttpServerExchange exchange, HttpHandler next) {
            this.exchange = exchange;
            this.next = next;
        }
    }
}

