/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public class SubscriptionInfo {
    private final String queueName;
    private final String clientID;
    private final String name;
    private final boolean durable;
    private final String selector;
    private final int messageCount;
    private final int deliveringCount;

    public static SubscriptionInfo[] from(String jsonString) throws Exception {
        JsonArray array = JsonUtil.readJsonArray(jsonString);
        SubscriptionInfo[] infos = new SubscriptionInfo[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            SubscriptionInfo info;
            JsonObject sub = array.getJsonObject(i);
            infos[i] = info = new SubscriptionInfo(sub.getString("queueName"), sub.getString("clientID", null), sub.getString("name", null), sub.getBoolean("durable"), sub.getString("selector", null), sub.getInt("messageCount"), sub.getInt("deliveringCount"));
        }
        return infos;
    }

    private SubscriptionInfo(String queueName, String clientID, String name, boolean durable, String selector, int messageCount, int deliveringCount) {
        this.queueName = queueName;
        this.clientID = clientID;
        this.name = name;
        this.durable = durable;
        this.selector = selector;
        this.messageCount = messageCount;
        this.deliveringCount = deliveringCount;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getSelector() {
        return this.selector;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getDeliveringCount() {
        return this.deliveringCount;
    }
}

