/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class EqualsFilterSpec
extends FilterSpec {
    private final String attribute;
    private final AttributeValue value;

    EqualsFilterSpec(String attribute, AttributeValue value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        return this.value.equals(attributes.get(this.attribute));
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        Collection<AttributeValue> collection = attributes.get(this.attribute);
        return collection != null && collection.contains(this.value);
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        return attributeNames.contains(this.attribute);
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        return true;
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('=');
        builder.append(this.value);
        builder.append(')');
    }
}

