/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.command;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jolokia.jvmagent.client.command.AbstractBaseCommand;
import org.jolokia.jvmagent.client.command.EncryptCommand;
import org.jolokia.jvmagent.client.command.HelpCommand;
import org.jolokia.jvmagent.client.command.ListCommand;
import org.jolokia.jvmagent.client.command.StartCommand;
import org.jolokia.jvmagent.client.command.StatusCommand;
import org.jolokia.jvmagent.client.command.StopCommand;
import org.jolokia.jvmagent.client.command.ToggleCommand;
import org.jolokia.jvmagent.client.command.VersionCommand;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandler;

public class CommandDispatcher {
    private OptionsAndArgs options;
    private static final Map<String, AbstractBaseCommand> COMMANDS = new HashMap<String, AbstractBaseCommand>();

    public CommandDispatcher(OptionsAndArgs pOptions) {
        this.options = pOptions;
    }

    public int dispatchCommand(Object pVm, VirtualMachineHandler pHandler) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String commandName = this.options.getCommand();
        AbstractBaseCommand command = COMMANDS.get(commandName);
        if (command == null) {
            throw new IllegalArgumentException("Unknown command '" + commandName + "'");
        }
        return command.execute(this.options, pVm, pHandler);
    }

    public static Set<String> getAvailableCommands() {
        return Collections.unmodifiableSet(COMMANDS.keySet());
    }

    public static void printHelp() {
        HelpCommand.printUsage();
    }

    static {
        for (AbstractBaseCommand command : new AbstractBaseCommand[]{new StartCommand(), new StopCommand(), new ToggleCommand(), new StatusCommand(), new ListCommand(), new EncryptCommand(), new HelpCommand(), new VersionCommand()}) {
            COMMANDS.put(command.getName(), command);
        }
    }
}

