/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.protocol;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.protocol.AbstractURLConnection;
import org.jboss.vfs.spi.RootFileSystem;

public class FileURLConnection
extends AbstractURLConnection {
    private final RootFileSystem rootFileSystem = RootFileSystem.ROOT_INSTANCE;
    private final VirtualFile mountPoint = VFS.getRootVirtualFile();
    private final VirtualFile file;

    public FileURLConnection(URL url) throws IOException {
        super(url);
        this.file = VFS.getChild(FileURLConnection.toURI(url));
    }

    @Override
    public File getContent() throws IOException {
        return this.rootFileSystem.getFile(this.mountPoint, this.file);
    }

    @Override
    public int getContentLength() {
        long size = this.rootFileSystem.getSize(this.mountPoint, this.file);
        return size > Integer.MAX_VALUE ? -1 : (int)size;
    }

    @Override
    public long getLastModified() {
        return this.rootFileSystem.getLastModified(this.mountPoint, this.file);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.rootFileSystem.openInputStream(this.mountPoint, this.file);
    }

    @Override
    public Permission getPermission() throws IOException {
        return new FilePermission(this.file.getPathName(), "read");
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    protected String getName() {
        return this.file.getName();
    }
}

