/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.resolvers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class FileResolver
implements ModelNodeResolver<String> {
    public static final FileResolver INSTANCE = new FileResolver();

    private FileResolver() {
    }

    @Override
    public String resolveValue(OperationContext context, ModelNode value) throws OperationFailedException {
        String path;
        ModelNode pathNode = PathResourceDefinition.PATH.resolveModelAttribute(context, value);
        ModelNode relativeToNode = PathResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, value);
        String result = path = pathNode.asString();
        if (relativeToNode.isDefined()) {
            result = this.resolve(context, relativeToNode.asString(), path);
        }
        if (result == null) {
            throw new IllegalStateException(LoggingLogger.ROOT_LOGGER.pathManagerServiceNotStarted());
        }
        Path file = Paths.get(result, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
            throw LoggingLogger.ROOT_LOGGER.invalidLogFile(file.normalize().toString());
        }
        return result;
    }

    public static String resolvePath(OperationContext context, String relativeToPath, String path) {
        return INSTANCE.resolve(context, relativeToPath, path);
    }

    private String resolve(OperationContext context, String relativeToPath, String path) {
        ServiceName pathMgrSvc = context.getCapabilityServiceName("org.wildfly.management.path-manager", PathManager.class);
        ServiceController controller = context.getServiceRegistry(false).getService(pathMgrSvc);
        if (controller == null) {
            return null;
        }
        return ((PathManager)controller.getValue()).resolveRelativePathEntry(path, relativeToPath);
    }
}

