/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.SecurityActions;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;

public class GlobalStateConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<String> PERSISTENT_LOCATION = AttributeDefinition.builder((String)"persistentLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> SHARED_PERSISTENT_LOCATION = AttributeDefinition.builder((String)"sharedPersistentLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> TEMPORARY_LOCATION = AttributeDefinition.builder((String)"temporaryLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("java.io.tmpdir")).immutable().build();
    public static final AttributeDefinition<ConfigurationStorage> CONFIGURATION_STORAGE = AttributeDefinition.builder((String)"configurationStorage", (Object)((Object)ConfigurationStorage.VOLATILE), ConfigurationStorage.class).autoPersist(false).immutable().build();
    public static final AttributeDefinition<Supplier<? extends LocalConfigurationStorage>> CONFIGURATION_STORAGE_SUPPLIER = AttributeDefinition.supplierBuilder((String)"configurationStorageSupplier", LocalConfigurationStorage.class).autoPersist(false).immutable().build();
    private final AttributeSet attributes;
    private final Attribute<Boolean> enabled;
    private final Attribute<String> persistentLocation;
    private Attribute<String> sharedPersistentLocation;
    private final Attribute<String> temporaryLocation;
    private final Attribute<ConfigurationStorage> configurationStorage;
    private final Attribute<Supplier<? extends LocalConfigurationStorage>> configurationStorageSupplier;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, new AttributeDefinition[]{ENABLED, PERSISTENT_LOCATION, SHARED_PERSISTENT_LOCATION, TEMPORARY_LOCATION, CONFIGURATION_STORAGE, CONFIGURATION_STORAGE_SUPPLIER});
    }

    public GlobalStateConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.persistentLocation = attributes.attribute(PERSISTENT_LOCATION);
        this.sharedPersistentLocation = attributes.attribute(SHARED_PERSISTENT_LOCATION);
        this.temporaryLocation = attributes.attribute(TEMPORARY_LOCATION);
        this.configurationStorage = attributes.attribute(CONFIGURATION_STORAGE);
        this.configurationStorageSupplier = attributes.attribute(CONFIGURATION_STORAGE_SUPPLIER);
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public String persistentLocation() {
        return (String)this.persistentLocation.get();
    }

    public String sharedPersistentLocation() {
        return (String)this.sharedPersistentLocation.get();
    }

    public String temporaryLocation() {
        return (String)this.temporaryLocation.get();
    }

    public ConfigurationStorage configurationStorage() {
        return (ConfigurationStorage)((Object)this.configurationStorage.get());
    }

    public Supplier<? extends LocalConfigurationStorage> configurationStorageClass() {
        return (Supplier)this.configurationStorageSupplier.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalStateConfiguration [attributes=" + this.attributes + "]";
    }
}

