/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.Experimental;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;

public interface RpcManager {
    @Experimental
    public <T> CompletionStage<T> invokeCommand(Address var1, ReplicableCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    @Experimental
    public <T> CompletionStage<T> invokeCommand(Collection<Address> var1, ReplicableCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    @Experimental
    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand var1, ResponseCollector<T> var2, RpcOptions var3);

    @Experimental
    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> var1, ReplicableCommand var2, ResponseCollector<T> var3, RpcOptions var4);

    @Experimental
    public <T> CompletionStage<T> invokeCommands(Collection<Address> var1, Function<Address, ReplicableCommand> var2, ResponseCollector<T> var3, RpcOptions var4);

    @Experimental
    public <T> T blocking(CompletionStage<T> var1);

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> var1, ReplicableCommand var2, RpcOptions var3);

    @Deprecated
    public Map<Address, Response> invokeRemotely(Collection<Address> var1, ReplicableCommand var2, RpcOptions var3);

    @Deprecated
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> var1, RpcOptions var2);

    public void sendTo(Address var1, ReplicableCommand var2, DeliverOrder var3);

    public void sendToMany(Collection<Address> var1, ReplicableCommand var2, DeliverOrder var3);

    @Experimental
    public void sendToAll(ReplicableCommand var1, DeliverOrder var2);

    public Transport getTransport();

    public List<Address> getMembers();

    public Address getAddress();

    public int getTopologyId();

    public RpcOptions getSyncRpcOptions();

    public RpcOptions getTotalSyncRpcOptions();

    @Deprecated
    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode var1);

    @Deprecated
    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode var1, DeliverOrder var2);

    @Deprecated
    public RpcOptions getDefaultRpcOptions(boolean var1);

    @Deprecated
    public RpcOptions getDefaultRpcOptions(boolean var1, DeliverOrder var2);
}

